/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.service.mcs.DataSetService;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/data-sets/{DATASET}/assignments")
@Component
@Scope(value="request")
public class DataSetAssignmentsResource {
    @Autowired
    private DataSetService dataSetService;

    @POST
    @PreAuthorize(value="hasPermission(#dataSetId.concat('/').concat(#providerId), 'eu.europeana.cloud.common.model.DataSet', write)")
    public void addAssignment(@PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="DATASET") String dataSetId, @FormParam(value="cloudId") String recordId, @FormParam(value="representationName") String schema, @FormParam(value="version") String representationVersion) throws DataSetNotExistsException, RepresentationNotExistsException {
        ParamUtil.require((String)"cloudId", (Object)recordId);
        ParamUtil.require((String)"representationName", (Object)schema);
        this.dataSetService.addAssignment(providerId, dataSetId, recordId, schema, representationVersion);
    }

    @DELETE
    @PreAuthorize(value="hasPermission(#dataSetId.concat('/').concat(#providerId), 'eu.europeana.cloud.common.model.DataSet', write)")
    public void removeAssignment(@PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="DATASET") String dataSetId, @QueryParam(value="cloudId") String recordId, @QueryParam(value="representationName") String schema, @QueryParam(value="version") String versionId) throws DataSetNotExistsException {
        ParamUtil.require((String)"cloudId", (Object)recordId);
        ParamUtil.require((String)"representationName", (Object)schema);
        ParamUtil.require((String)"version", (Object)versionId);
        this.dataSetService.removeAssignment(providerId, dataSetId, recordId, schema, versionId);
    }
}

