/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest.exceptionmappers;

import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.mcs.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.CannotPersistEmptyRepresentationException;
import eu.europeana.cloud.service.mcs.exception.DataSetAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.FileAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.FileContentHashMismatchException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RevisionIsNotValidException;
import eu.europeana.cloud.service.mcs.exception.RevisionNotExistsException;
import eu.europeana.cloud.service.mcs.exception.VersionNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import eu.europeana.cloud.service.mcs.status.McsErrorCode;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

/*
 * Exception performing whole class analysis ignored.
 */
public class UnitedExceptionMapper {
    static final int UNPROCESSABLE_ENTITY = 422;
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitedExceptionMapper.class);

    public Response toResponse(CannotModifyPersistentRepresentationException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (McsErrorCode)McsErrorCode.CANNOT_MODIFY_PERSISTENT_REPRESENTATION, (Exception)exception);
    }

    public Response toResponse(CannotPersistEmptyRepresentationException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (McsErrorCode)McsErrorCode.CANNOT_PERSIST_EMPTY_REPRESENTATION, (Exception)exception);
    }

    public Response toResponse(DataSetAlreadyExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.CONFLICT, (McsErrorCode)McsErrorCode.DATASET_ALREADY_EXISTS, (Exception)exception);
    }

    public Response toResponse(DataSetNotExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.NOT_FOUND, (McsErrorCode)McsErrorCode.DATASET_NOT_EXISTS, (Exception)exception);
    }

    public Response toResponse(FileAlreadyExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.CONFLICT, (McsErrorCode)McsErrorCode.FILE_ALREADY_EXISTS, (Exception)exception);
    }

    public Response toResponse(FileNotExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.NOT_FOUND, (McsErrorCode)McsErrorCode.FILE_NOT_EXISTS, (Exception)((Object)exception));
    }

    public Response toResponse(RecordNotExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.NOT_FOUND, (McsErrorCode)McsErrorCode.RECORD_NOT_EXISTS, (Exception)exception);
    }

    public Response toResponse(RepresentationNotExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.NOT_FOUND, (McsErrorCode)McsErrorCode.REPRESENTATION_NOT_EXISTS, (Exception)exception);
    }

    public Response toResponse(VersionNotExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.NOT_FOUND, (McsErrorCode)McsErrorCode.VERSION_NOT_EXISTS, (Exception)exception);
    }

    public Response toResponse(FileContentHashMismatchException exception) {
        return UnitedExceptionMapper.buildResponse((int)422, (McsErrorCode)McsErrorCode.FILE_CONTENT_HASH_MISMATCH, (Exception)exception);
    }

    public Response toResponse(WrongContentRangeException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.REQUESTED_RANGE_NOT_SATISFIABLE, (McsErrorCode)McsErrorCode.WRONG_CONTENT_RANGE, (Exception)exception);
    }

    public Response toResponse(RuntimeException exception) {
        if (exception instanceof AccessDeniedException) {
            return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (McsErrorCode)McsErrorCode.ACCESS_DENIED_OR_OBJECT_DOES_NOT_EXIST_EXCEPTION, (Exception)exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.BAD_REQUEST, (McsErrorCode)McsErrorCode.BAD_PARAMETER_VALUE, (Exception)exception);
        }
        LOGGER.error("Unexpected error occured.", (Throwable)exception);
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (McsErrorCode)McsErrorCode.OTHER, (Exception)exception);
    }

    public Response toResponse(WebApplicationException exception) {
        return UnitedExceptionMapper.buildResponse((int)exception.getResponse().getStatus(), (McsErrorCode)McsErrorCode.OTHER, (Exception)exception);
    }

    public Response toResponse(ProviderNotExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.NOT_FOUND, (McsErrorCode)McsErrorCode.PROVIDER_NOT_EXISTS, (Exception)exception);
    }

    public Response toResponse(AccessDeniedOrObjectDoesNotExistException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (McsErrorCode)McsErrorCode.ACCESS_DENIED_OR_OBJECT_DOES_NOT_EXIST_EXCEPTION, (Exception)exception);
    }

    public Response toResponse(RevisionIsNotValidException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (McsErrorCode)McsErrorCode.REVISION_IS_NOT_VALID, (Exception)exception);
    }

    public Response toResponse(RevisionNotExistsException exception) {
        return UnitedExceptionMapper.buildResponse((Response.Status)Response.Status.NOT_FOUND, (McsErrorCode)McsErrorCode.REVISION_NOT_EXISTS, (Exception)exception);
    }

    private static Response buildResponse(Response.Status httpStatus, McsErrorCode errorCode, Exception e) {
        return UnitedExceptionMapper.buildResponse((int)httpStatus.getStatusCode(), (McsErrorCode)errorCode, (Exception)e);
    }

    private static Response buildResponse(int httpStatusCode, McsErrorCode errorCode, Exception e) {
        return Response.status((int)httpStatusCode).type("application/xml").entity((Object)new ErrorInfo(errorCode.name(), e.getMessage())).build();
    }
}

