/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.UISClientHandler;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/records/{LOCALID:.+}")
@Component
@Scope(value="request")
public class SimplifiedRecordsResource {
    @Autowired
    private RecordService recordService;
    @Autowired
    private UISClientHandler uisHandler;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Record getRecord(@Context UriInfo uriInfo, @PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="LOCALID") String localId) throws CloudException, RecordNotExistsException, ProviderNotExistsException {
        String cloudId = this.findCloudIdFor(providerId, localId);
        Record record = this.recordService.getRecord(cloudId);
        this.prepare(uriInfo, record);
        return record;
    }

    private String findCloudIdFor(String providerId, String localId) throws ProviderNotExistsException, RecordNotExistsException {
        CloudId foundCloudId = this.uisHandler.getCloudIdFromProviderAndLocalId(providerId, localId);
        return foundCloudId.getId();
    }

    private void prepare(@Context UriInfo uriInfo, Record record) {
        EnrichUriUtil.enrich((UriInfo)uriInfo, (Record)record);
        for (Representation representation : record.getRepresentations()) {
            representation.setCloudId(null);
        }
    }
}

