/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.RepresentationRevisionResponse;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/revisions/{REVISION_NAME}")
@Component
@Scope(value="request")
public class RepresentationRevisionsResource {
    @Autowired
    private RecordService recordService;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @PostAuthorize(value="returnObject.version != null ? hasPermission(  (#globalId).concat('/').concat(#schema).concat('/').concat(returnObject.version) , 'eu.europeana.cloud.common.model.Representation', read) : true")
    @ReturnType(value="eu.europeana.cloud.common.response.RepresentationRevisionResponse")
    public RepresentationRevisionResponse getRepresentationRevision(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="REVISION_NAME") String revisionName, @QueryParam(value="revisionProviderId") String revisionProviderId, @QueryParam(value="revisionTimestamp") String revisionTimestamp) {
        RepresentationRevisionResponse info;
        if (revisionProviderId == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorInfo("OTHER", "revisionProviderId parameter cannot be empty.")).build());
        }
        Date revisionDate = null;
        if (revisionTimestamp != null) {
            DateTime utc = new DateTime((Object)revisionTimestamp, DateTimeZone.UTC);
            revisionDate = utc.toDate();
        }
        if ((info = this.recordService.getRepresentationRevision(globalId, schema, revisionProviderId, revisionName, revisionDate)) != null) {
            EnrichUriUtil.enrich((UriInfo)uriInfo, (RepresentationRevisionResponse)info);
        } else {
            info = new RepresentationRevisionResponse();
            try {
                this.recordService.getRecord(globalId);
                this.recordService.getRepresentation(globalId, schema);
            }
            catch (RepresentationNotExistsException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorInfo("REPRESENTATION_NOT_EXISTS", "Representation " + schema + " does not exist.")).build());
            }
            catch (RecordNotExistsException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorInfo("RECORD_NOT_EXISTS", "Record " + globalId + " does not exist.")).build());
            }
        }
        return info;
    }
}

