/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.FileAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import eu.europeana.cloud.service.mcs.rest.storage.selector.PreBufferedInputStream;
import eu.europeana.cloud.service.mcs.rest.storage.selector.StorageSelector;
import java.io.InputStream;
import java.net.URI;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/files")
@Component
@Scope(value="request")
public class FilesResource {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RequestsLogger");
    @Autowired
    private RecordService recordService;
    @Autowired
    private MutableAclService mutableAclService;
    @Autowired
    private Integer objectStoreSizeThreshold;

    @POST
    @Consumes(value={"multipart/form-data"})
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', write)")
    public Response sendFile(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, @FormDataParam(value="mimeType") String mimeType, @FormDataParam(value="data") InputStream data, @FormDataParam(value="fileName") String fileName) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, FileAlreadyExistsException {
        ParamUtil.require((String)"data", (Object)data);
        ParamUtil.require((String)"mimeType", (Object)mimeType);
        File f = new File();
        f.setMimeType(mimeType);
        PreBufferedInputStream prebufferedInputStream = PreBufferedInputStream.wrap((InputStream)data, (int)this.objectStoreSizeThreshold);
        f.setFileStorage(new StorageSelector(prebufferedInputStream, mimeType).selectStorage());
        if (fileName != null) {
            try {
                File temp = this.recordService.getFile(globalId, schema, version, fileName);
                if (temp != null) {
                    throw new FileAlreadyExistsException(fileName);
                }
            }
            catch (FileNotExistsException e) {
                // empty catch block
            }
        }
        if (fileName == null) {
            fileName = UUID.randomUUID().toString();
        }
        f.setFileName(fileName);
        this.recordService.putContent(globalId, schema, version, f, (InputStream)prebufferedInputStream);
        IOUtils.closeQuietly((InputStream)prebufferedInputStream);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (String)globalId, (String)schema, (String)version, (File)f);
        LOGGER.debug(String.format("File added [%s, %s, %s], uri: %s ", globalId, schema, version, f.getContentUri()));
        return Response.created((URI)f.getContentUri()).tag(f.getMd5()).build();
    }
}

