/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.Storage;
import eu.europeana.cloud.service.mcs.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.CannotPersistEmptyRepresentationException;
import eu.europeana.cloud.service.mcs.exception.FileAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import eu.europeana.cloud.service.mcs.rest.storage.selector.PreBufferedInputStream;
import eu.europeana.cloud.service.mcs.rest.storage.selector.StorageSelector;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/files")
@Component
@Scope(value="request")
public class FileUploadResource {
    @Autowired
    private RecordService recordService;
    @Autowired
    private MutableAclService mutableAclService;
    @Autowired
    private Integer objectStoreSizeThreshold;
    private final String REPRESENTATION_CLASS_NAME = Representation.class.getName();

    @POST
    @Consumes(value={"multipart/form-data"})
    @PreAuthorize(value="isAuthenticated()")
    public Response sendFile(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @FormDataParam(value="fileName") String fileName, @FormDataParam(value="providerId") String providerId, @FormDataParam(value="mimeType") String mimeType, @FormDataParam(value="data") InputStream data) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, FileNotExistsException, RecordNotExistsException, ProviderNotExistsException, FileAlreadyExistsException, AccessDeniedOrObjectDoesNotExistException, CannotPersistEmptyRepresentationException {
        ParamUtil.require((String)"fileName", (Object)fileName);
        ParamUtil.require((String)"providerId", (Object)providerId);
        ParamUtil.require((String)"data", (Object)data);
        ParamUtil.require((String)"mimeType", (Object)mimeType);
        PreBufferedInputStream prebufferedInputStream = PreBufferedInputStream.wrap((InputStream)data, (int)this.objectStoreSizeThreshold);
        Storage storage = new StorageSelector(prebufferedInputStream, mimeType).selectStorage();
        Representation representation = null;
        representation = this.recordService.createRepresentation(globalId, schema, providerId);
        this.addPrivilegesToRepresentation(representation);
        File file = this.addFileToRepresentation(representation, (InputStream)prebufferedInputStream, mimeType, fileName, storage);
        this.persistRepresentation(representation);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (String)globalId, (String)schema, (String)representation.getVersion(), (File)file);
        return Response.created((URI)file.getContentUri()).tag(file.getMd5()).build();
    }

    private void addPrivilegesToRepresentation(Representation representation) {
        String creatorName = SpringUserUtils.getUsername();
        if (creatorName != null) {
            ObjectIdentityImpl versionIdentity = new ObjectIdentityImpl(this.REPRESENTATION_CLASS_NAME, (Serializable)((Object)(representation.getCloudId() + "/" + representation.getRepresentationName() + "/" + representation.getVersion())));
            MutableAcl versionAcl = this.mutableAclService.createAcl((ObjectIdentity)versionIdentity);
            versionAcl.insertAce(0, BasePermission.READ, (Sid)new PrincipalSid(creatorName), true);
            versionAcl.insertAce(1, BasePermission.WRITE, (Sid)new PrincipalSid(creatorName), true);
            versionAcl.insertAce(2, BasePermission.DELETE, (Sid)new PrincipalSid(creatorName), true);
            versionAcl.insertAce(3, BasePermission.ADMINISTRATION, (Sid)new PrincipalSid(creatorName), true);
            this.mutableAclService.updateAcl(versionAcl);
        }
    }

    private File addFileToRepresentation(Representation representation, InputStream data, String mimeType, String fileName, Storage storage) throws RepresentationNotExistsException, FileAlreadyExistsException, CannotModifyPersistentRepresentationException {
        File f = new File();
        f.setMimeType(mimeType);
        f.setFileStorage(storage);
        if (fileName != null) {
            try {
                File temp = this.recordService.getFile(representation.getCloudId(), representation.getRepresentationName(), representation.getVersion(), fileName);
                if (temp != null) {
                    throw new FileAlreadyExistsException(fileName);
                }
            }
            catch (FileNotExistsException e) {
                // empty catch block
            }
        }
        if (fileName == null) {
            fileName = UUID.randomUUID().toString();
        }
        f.setFileName(fileName);
        this.recordService.putContent(representation.getCloudId(), representation.getRepresentationName(), representation.getVersion(), f, data);
        IOUtils.closeQuietly((InputStream)data);
        return f;
    }

    private void persistRepresentation(Representation representation) throws CannotModifyPersistentRepresentationException, CannotPersistEmptyRepresentationException, RepresentationNotExistsException {
        this.recordService.persistRepresentation(representation.getCloudId(), representation.getRepresentationName(), representation.getVersion());
    }
}

