/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.CloudIdAndTimestampResponse;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.model.RepresentationNames;
import eu.europeana.cloud.common.response.CloudVersionRevisionResponse;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.common.utils.Tags;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.mcs.DataSetService;
import eu.europeana.cloud.service.mcs.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import java.io.Serializable;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/data-sets/{DATASET}")
@Component
@Scope(value="request")
public class DataSetResource {
    @Autowired
    private DataSetService dataSetService;
    @Autowired
    private MutableAclService mutableAclService;
    @Value(value="${numberOfElementsOnPage}")
    private int numberOfElementsOnPage;
    private final String DATASET_CLASS_NAME = DataSet.class.getName();

    @DELETE
    @PreAuthorize(value="hasPermission(#dataSetId.concat('/').concat(#providerId), 'eu.europeana.cloud.common.model.DataSet', delete)")
    public void deleteDataSet(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId) throws DataSetNotExistsException {
        this.dataSetService.deleteDataSet(providerId, dataSetId);
        String ownersName = SpringUserUtils.getUsername();
        if (ownersName != null) {
            ObjectIdentityImpl dataSetIdentity = new ObjectIdentityImpl(this.DATASET_CLASS_NAME, (Serializable)((Object)(dataSetId + "/" + providerId)));
            this.mutableAclService.deleteAcl((ObjectIdentity)dataSetIdentity, false);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<eu.europeana.cloud.common.model.Representation>")
    public ResultSlice<Representation> getDataSetContents(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="startFrom") String startFrom) throws DataSetNotExistsException {
        return this.dataSetService.listDataSet(providerId, dataSetId, startFrom, this.numberOfElementsOnPage);
    }

    @PUT
    @PreAuthorize(value="hasPermission(#dataSetId.concat('/').concat(#providerId), 'eu.europeana.cloud.common.model.DataSet', write)")
    public void updateDataSet(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId, @FormParam(value="description") String description) throws AccessDeniedOrObjectDoesNotExistException, DataSetNotExistsException {
        this.dataSetService.updateDataSet(providerId, dataSetId, description);
    }

    @Path(value="/representationsNames")
    @Produces(value={"application/json", "application/xml"})
    @GET
    public RepresentationNames getRepresentationsNames(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId) throws ProviderNotExistsException, DataSetNotExistsException {
        RepresentationNames representationNames = new RepresentationNames();
        representationNames.setNames(this.dataSetService.getAllDataSetRepresentationsNames(providerId, dataSetId));
        return representationNames;
    }

    @Path(value="/representations/{REPRESENTATIONNAME}")
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<CloudVersionRevisionResponse>")
    @GET
    public ResultSlice<CloudVersionRevisionResponse> getDataSetCloudIdsByRepresentation(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="REPRESENTATIONNAME") String representationName, @QueryParam(value="creationDateFrom") String dateFrom, @QueryParam(value="tag") String tag, @QueryParam(value="startFrom") String startFrom) throws ProviderNotExistsException, DataSetNotExistsException {
        Tags tags = Tags.valueOf((String)tag.toUpperCase());
        DateTime utc = new DateTime((Object)dateFrom, DateTimeZone.UTC);
        if (Tags.PUBLISHED.equals((Object)tags)) {
            return this.dataSetService.getDataSetCloudIdsByRepresentationPublished(dataSetId, providerId, representationName, utc.toDate(), startFrom, this.numberOfElementsOnPage);
        }
        throw new IllegalArgumentException("Only PUBLISHED tag is supported for this request.");
    }

    @Path(value="/revision/{REVISION_NAME}/revisionProvider/{revisionProvider}/representations/{REPRESENTATIONNAME}")
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<CloudIdAndTimestampResponse>")
    @GET
    public ResultSlice<CloudIdAndTimestampResponse> getDataSetCloudIdsByRepresentationAndRevision(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="REVISION_NAME") String revisionName, @PathParam(value="revisionProvider") String revisionProvider, @PathParam(value="REPRESENTATIONNAME") String representationName, @QueryParam(value="startFrom") String startFrom, @QueryParam(value="deleted") Boolean isDeleted) throws ProviderNotExistsException, DataSetNotExistsException {
        ResultSlice cloudIdAndTimestampResponses = this.dataSetService.getLatestDataSetCloudIdByRepresentationAndRevision(dataSetId, providerId, revisionName, revisionProvider, representationName, startFrom, isDeleted, this.numberOfElementsOnPage);
        return cloudIdAndTimestampResponses;
    }

    @Path(value="/latelyRevisionedVersion")
    @Produces(value={"application/json", "application/xml"})
    @GET
    public Response getLatelyTaggedRecords(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="cloudId") String cloudId, @QueryParam(value="representationName") String representationName, @QueryParam(value="revisionName") String revisionName, @QueryParam(value="revisionProviderId") String revisionProviderId) throws DataSetNotExistsException {
        ParamUtil.require((String)"cloudId", (Object)cloudId);
        ParamUtil.require((String)"representationName", (Object)representationName);
        ParamUtil.require((String)"revisionName", (Object)revisionName);
        ParamUtil.require((String)"revisionProviderId", (Object)revisionProviderId);
        String versionId = this.dataSetService.getLatestVersionForGivenRevision(dataSetId, providerId, cloudId, representationName, revisionName, revisionProviderId);
        if (versionId != null) {
            return Response.ok().entity((Object)versionId).build();
        }
        return Response.noContent().build();
    }
}

