/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions")
@Component
@Scope(value="request")
public class RepresentationVersionsResource {
    @Autowired
    private RecordService recordService;
    @Context
    private UriInfo uriInfo;
    @PathParam(value="CLOUDID")
    private String globalId;
    @PathParam(value="REPRESENTATIONNAME")
    private String representation;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="java.util.List<eu.europeana.cloud.common.model.Representation>")
    public List<Representation> listVersions() throws RepresentationNotExistsException {
        List representationVersions = this.recordService.listRepresentationVersions(this.globalId, this.representation);
        for (Representation representationVersion : representationVersions) {
            this.prepare(representationVersion);
        }
        return representationVersions;
    }

    private void prepare(Representation representationVersion) {
        EnrichUriUtil.enrich((UriInfo)this.uriInfo, (Representation)representationVersion);
    }
}

