/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}")
@Component
@Scope(value="request")
public class RecordsResource {
    @Autowired
    private RecordService recordService;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.model.Record")
    public Record getRecord(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId) throws RecordNotExistsException {
        Record record = this.recordService.getRecord(globalId);
        this.prepare(uriInfo, record);
        return record;
    }

    @DELETE
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteRecord(@PathParam(value="CLOUDID") String globalId) throws RecordNotExistsException, RepresentationNotExistsException {
        this.recordService.deleteRecord(globalId);
    }

    private void prepare(@Context UriInfo uriInfo, Record record) {
        EnrichUriUtil.enrich((UriInfo)uriInfo, (Record)record);
        for (Representation representation : record.getRepresentations()) {
            representation.setCloudId(null);
        }
    }
}

