/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.mcs.DataSetService;
import eu.europeana.cloud.service.mcs.exception.AccessDeniedOrObjectDoesNotExistException;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import java.io.Serializable;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/data-sets/{DATASET}")
@Component
@Scope(value="request")
public class DataSetResource {
    @Autowired
    private DataSetService dataSetService;
    @Autowired
    private MutableAclService mutableAclService;
    @Value(value="${numberOfElementsOnPage}")
    private int numberOfElementsOnPage;
    private final String DATASET_CLASS_NAME = DataSet.class.getName();

    @DELETE
    @PreAuthorize(value="hasPermission(#dataSetId.concat('/').concat(#providerId), 'eu.europeana.cloud.common.model.DataSet', delete)")
    public void deleteDataSet(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId) throws DataSetNotExistsException {
        this.dataSetService.deleteDataSet(providerId, dataSetId);
        String ownersName = SpringUserUtils.getUsername();
        if (ownersName != null) {
            ObjectIdentityImpl dataSetIdentity = new ObjectIdentityImpl(this.DATASET_CLASS_NAME, (Serializable)((Object)(dataSetId + "/" + providerId)));
            this.mutableAclService.deleteAcl((ObjectIdentity)dataSetIdentity, false);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<eu.europeana.cloud.common.model.Representation>")
    public ResultSlice<Representation> getDataSetContents(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="startFrom") String startFrom) throws DataSetNotExistsException {
        return this.dataSetService.listDataSet(providerId, dataSetId, startFrom, this.numberOfElementsOnPage);
    }

    @PUT
    @PreAuthorize(value="hasPermission(#dataSetId.concat('/').concat(#providerId), 'eu.europeana.cloud.common.model.DataSet', write)")
    public void updateDataSet(@PathParam(value="DATASET") String dataSetId, @PathParam(value="DATAPROVIDER") String providerId, @FormParam(value="description") String description) throws AccessDeniedOrObjectDoesNotExistException, DataSetNotExistsException {
        this.dataSetService.updateDataSet(providerId, dataSetId, description);
    }
}

