/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import eu.europeana.cloud.service.mcs.rest.FileResource;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/files/{FILENAME}")
@Component
@Scope(value="request")
public class FileResource {
    @Autowired
    private RecordService recordService;
    private static final String HEADER_RANGE = "Range";
    @Autowired
    private MutableAclService mutableAclService;
    private final String REPRESENTATION_CLASS_NAME = Representation.class.getName();

    @PUT
    @Consumes(value={"multipart/form-data"})
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', write)")
    public Response sendFile(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, @PathParam(value="FILENAME") String fileName, @FormDataParam(value="mimeType") String mimeType, @FormDataParam(value="data") InputStream data) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, FileNotExistsException {
        ParamUtil.require((String)"data", (Object)data);
        this.recordService.getFile(globalId, schema, version, fileName);
        File f = new File();
        f.setMimeType(mimeType);
        f.setFileName(fileName);
        this.recordService.putContent(globalId, schema, version, f, data);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (String)globalId, (String)schema, (String)version, (File)f);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).location(f.getContentUri()).tag(f.getMd5()).build();
    }

    @GET
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', read)")
    public Response getFile(@PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, @PathParam(value="FILENAME") String fileName, @HeaderParam(value="Range") String range) throws RepresentationNotExistsException, FileNotExistsException, WrongContentRangeException {
        Response.Status status;
        ContentRange contentRange = range == null ? new ContentRange(-1L, -1L) : ContentRange.parse((String)range);
        String md5 = null;
        if (contentRange.isSpecified()) {
            status = Response.Status.PARTIAL_CONTENT;
        } else {
            status = Response.Status.OK;
            File requestedFile = this.recordService.getFile(globalId, schema, version, fileName);
            md5 = requestedFile.getMd5();
        }
        1 output = new /* Unavailable Anonymous Inner Class!! */;
        return Response.status((Response.Status)status).entity((Object)output).tag(md5).build();
    }

    @DELETE
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', delete)")
    public void deleteFile(@PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, @PathParam(value="FILENAME") String fileName) throws RepresentationNotExistsException, FileNotExistsException, CannotModifyPersistentRepresentationException {
        this.recordService.deleteContent(globalId, schema, version, fileName);
    }

    static /* synthetic */ RecordService access$200(FileResource x0) {
        return x0.recordService;
    }
}

