/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.mcs.DataSetService;
import eu.europeana.cloud.service.mcs.exception.DataSetAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/data-sets")
@Component
@Scope(value="request")
public class DataSetsResource {
    @Autowired
    private DataSetService dataSetService;
    @Value(value="${numberOfElementsOnPage}")
    private int numberOfElementsOnPage;
    @Autowired
    private MutableAclService mutableAclService;
    private final String DATASET_CLASS_NAME = DataSet.class.getName();

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<eu.europeana.cloud.common.model.DataSet>")
    public ResultSlice<DataSet> getDataSets(@PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="startFrom") String startFrom) {
        return this.dataSetService.getDataSets(providerId, startFrom, this.numberOfElementsOnPage);
    }

    @POST
    @PreAuthorize(value="isAuthenticated()")
    public Response createDataSet(@Context UriInfo uriInfo, @PathParam(value="DATAPROVIDER") String providerId, @FormParam(value="dataSetId") String dataSetId, @FormParam(value="description") String description) throws ProviderNotExistsException, DataSetAlreadyExistsException {
        ParamUtil.require((String)"dataSetId", (Object)dataSetId);
        DataSet dataSet = this.dataSetService.createDataSet(providerId, dataSetId, description);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (DataSet)dataSet);
        Response response = Response.created((URI)dataSet.getUri()).build();
        String creatorName = SpringUserUtils.getUsername();
        if (creatorName != null) {
            ObjectIdentityImpl dataSetIdentity = new ObjectIdentityImpl(this.DATASET_CLASS_NAME, (Serializable)((Object)(dataSetId + "/" + providerId)));
            MutableAcl datasetAcl = this.mutableAclService.createAcl((ObjectIdentity)dataSetIdentity);
            datasetAcl.insertAce(0, BasePermission.READ, (Sid)new PrincipalSid(creatorName), true);
            datasetAcl.insertAce(1, BasePermission.WRITE, (Sid)new PrincipalSid(creatorName), true);
            datasetAcl.insertAce(2, BasePermission.DELETE, (Sid)new PrincipalSid(creatorName), true);
            datasetAcl.insertAce(3, BasePermission.ADMINISTRATION, (Sid)new PrincipalSid(creatorName), true);
            this.mutableAclService.updateAcl(datasetAcl);
        }
        return response;
    }
}

