/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.oc4j;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.instrument.classloading.oc4j.OC4JClassPreprocessorAdapter;
import org.springframework.util.Assert;

class OC4JClassLoaderAdapter {
    private static final String CL_UTILS = "oracle.classloader.util.ClassLoaderUtilities";
    private static final String PREPROCESS_UTILS = "oracle.classloader.util.ClassPreprocessor";
    private final ClassLoader classLoader;
    private final Class<?> processorClass;
    private final Method addTransformer;
    private final Method copy;

    public OC4JClassLoaderAdapter(ClassLoader classLoader) {
        try {
            Class<?> utilClass = classLoader.loadClass(CL_UTILS);
            this.processorClass = classLoader.loadClass(PREPROCESS_UTILS);
            this.addTransformer = utilClass.getMethod("addPreprocessor", ClassLoader.class, this.processorClass);
            this.copy = utilClass.getMethod("copy", ClassLoader.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize OC4J LoadTimeWeaver because OC4J API classes are not available", ex);
        }
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull((Object)transformer, "ClassFileTransformer must not be null");
        try {
            OC4JClassPreprocessorAdapter adapter = new OC4JClassPreprocessorAdapter(transformer);
            Object adapterInstance = Proxy.newProxyInstance(this.processorClass.getClassLoader(), new Class[]{this.processorClass}, (InvocationHandler)adapter);
            this.addTransformer.invoke(null, this.classLoader, adapterInstance);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("OC4J addPreprocessor method threw exception", ex.getCause());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not invoke OC4J addPreprocessor method", ex);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        try {
            return (ClassLoader)this.copy.invoke(null, this.classLoader);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("OC4J copy method failed", ex.getCause());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not copy OC4J classloader", ex);
        }
    }
}

