/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.springframework.instrument.InstrumentationSavingAgent;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class InstrumentationLoadTimeWeaver
implements LoadTimeWeaver {
    private static final boolean AGENT_CLASS_PRESENT = ClassUtils.isPresent("org.springframework.instrument.InstrumentationSavingAgent", InstrumentationLoadTimeWeaver.class.getClassLoader());
    private final ClassLoader classLoader;
    private final Instrumentation instrumentation;
    private final List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>(4);

    public InstrumentationLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public InstrumentationLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
        this.instrumentation = InstrumentationLoadTimeWeaver.getInstrumentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull((Object)transformer, "Transformer must not be null");
        FilteringClassFileTransformer actualTransformer = new FilteringClassFileTransformer(transformer, this.classLoader);
        List<ClassFileTransformer> list = this.transformers;
        synchronized (list) {
            if (this.instrumentation == null) {
                throw new IllegalStateException("Must start with Java agent to use InstrumentationLoadTimeWeaver. See Spring documentation.");
            }
            this.instrumentation.addTransformer(actualTransformer);
            this.transformers.add(actualTransformer);
        }
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransformers() {
        List<ClassFileTransformer> list = this.transformers;
        synchronized (list) {
            if (!this.transformers.isEmpty()) {
                int i = this.transformers.size() - 1;
                while (i >= 0) {
                    this.instrumentation.removeTransformer(this.transformers.get(i));
                    --i;
                }
                this.transformers.clear();
            }
        }
    }

    public static boolean isInstrumentationAvailable() {
        return InstrumentationLoadTimeWeaver.getInstrumentation() != null;
    }

    private static Instrumentation getInstrumentation() {
        if (AGENT_CLASS_PRESENT) {
            return InstrumentationAccessor.getInstrumentation();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringClassFileTransformer
    implements ClassFileTransformer {
        private final ClassFileTransformer targetTransformer;
        private final ClassLoader targetClassLoader;

        public FilteringClassFileTransformer(ClassFileTransformer targetTransformer, ClassLoader targetClassLoader) {
            this.targetTransformer = targetTransformer;
            this.targetClassLoader = targetClassLoader;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (!this.targetClassLoader.equals(loader)) {
                return null;
            }
            return this.targetTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }

        public String toString() {
            return "FilteringClassFileTransformer for: " + this.targetTransformer.toString();
        }
    }

    private static class InstrumentationAccessor {
        private InstrumentationAccessor() {
        }

        public static Instrumentation getInstrumentation() {
            return InstrumentationSavingAgent.getInstrumentation();
        }
    }
}

