/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.lang.reflect.SourceLocation;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.util.Assert;

public class MethodInvocationProceedingJoinPoint
implements ProceedingJoinPoint,
JoinPoint.StaticPart {
    private final ProxyMethodInvocation methodInvocation;
    private Object[] defensiveCopyOfArgs;
    private Signature signature;
    private SourceLocation sourceLocation;

    public MethodInvocationProceedingJoinPoint(ProxyMethodInvocation methodInvocation) {
        Assert.notNull((Object)methodInvocation, "MethodInvocation must not be null");
        this.methodInvocation = methodInvocation;
    }

    public void set$AroundClosure(AroundClosure aroundClosure) {
        throw new UnsupportedOperationException();
    }

    public Object proceed() throws Throwable {
        return this.methodInvocation.invocableClone().proceed();
    }

    public Object proceed(Object[] arguments) throws Throwable {
        Assert.notNull((Object)arguments, "Argument array passed to proceed cannot be null");
        if (arguments.length != this.methodInvocation.getArguments().length) {
            throw new IllegalArgumentException("Expecting " + this.methodInvocation.getArguments().length + " arguments to proceed, " + "but was passed " + arguments.length + " arguments");
        }
        this.methodInvocation.setArguments(arguments);
        return this.methodInvocation.invocableClone(arguments).proceed();
    }

    public Object getThis() {
        return this.methodInvocation.getProxy();
    }

    public Object getTarget() {
        return this.methodInvocation.getThis();
    }

    public Object[] getArgs() {
        if (this.defensiveCopyOfArgs == null) {
            Object[] argsSource = this.methodInvocation.getArguments();
            this.defensiveCopyOfArgs = new Object[argsSource.length];
            System.arraycopy(argsSource, 0, this.defensiveCopyOfArgs, 0, argsSource.length);
        }
        return this.defensiveCopyOfArgs;
    }

    public Signature getSignature() {
        if (this.signature == null) {
            this.signature = new MethodSignatureImpl();
        }
        return this.signature;
    }

    public SourceLocation getSourceLocation() {
        if (this.sourceLocation == null) {
            this.sourceLocation = new SourceLocationImpl();
        }
        return this.sourceLocation;
    }

    public String getKind() {
        return "method-execution";
    }

    public int getId() {
        return 0;
    }

    public JoinPoint.StaticPart getStaticPart() {
        return this;
    }

    public String toShortString() {
        return "execution(" + this.getSignature().toShortString() + ")";
    }

    public String toLongString() {
        return "execution(" + this.getSignature().toLongString() + ")";
    }

    public String toString() {
        return "execution(" + this.getSignature().toString() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodSignatureImpl
    implements MethodSignature {
        private volatile String[] parameterNames;

        private MethodSignatureImpl() {
        }

        public String getName() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getName();
        }

        public int getModifiers() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getModifiers();
        }

        public Class getDeclaringType() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getDeclaringClass();
        }

        public String getDeclaringTypeName() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getDeclaringClass().getName();
        }

        public Class getReturnType() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getReturnType();
        }

        public Method getMethod() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod();
        }

        public Class[] getParameterTypes() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getParameterTypes();
        }

        public String[] getParameterNames() {
            if (this.parameterNames == null) {
                this.parameterNames = new LocalVariableTableParameterNameDiscoverer().getParameterNames(this.getMethod());
            }
            return this.parameterNames;
        }

        public Class[] getExceptionTypes() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getExceptionTypes();
        }

        public String toShortString() {
            return this.toString(false, false, false, false);
        }

        public String toLongString() {
            return this.toString(true, true, true, true);
        }

        public String toString() {
            return this.toString(false, true, false, true);
        }

        private String toString(boolean includeModifier, boolean includeReturnTypeAndArgs, boolean useLongReturnAndArgumentTypeName, boolean useLongTypeName) {
            StringBuilder sb = new StringBuilder();
            if (includeModifier) {
                sb.append(Modifier.toString(this.getModifiers()));
                sb.append(" ");
            }
            if (includeReturnTypeAndArgs) {
                this.appendType(sb, this.getReturnType(), useLongReturnAndArgumentTypeName);
                sb.append(" ");
            }
            this.appendType(sb, this.getDeclaringType(), useLongTypeName);
            sb.append(".");
            sb.append(this.getMethod().getName());
            sb.append("(");
            Class[] parametersTypes = this.getParameterTypes();
            this.appendTypes(sb, parametersTypes, includeReturnTypeAndArgs, useLongReturnAndArgumentTypeName);
            sb.append(")");
            return sb.toString();
        }

        private void appendTypes(StringBuilder sb, Class<?>[] types, boolean includeArgs, boolean useLongReturnAndArgumentTypeName) {
            if (includeArgs) {
                int size = types.length;
                int i = 0;
                while (i < size) {
                    this.appendType(sb, types[i], useLongReturnAndArgumentTypeName);
                    if (i < size - 1) {
                        sb.append(",");
                    }
                    ++i;
                }
            } else if (types.length != 0) {
                sb.append("..");
            }
        }

        private void appendType(StringBuilder sb, Class<?> type, boolean useLongTypeName) {
            if (type.isArray()) {
                this.appendType(sb, type.getComponentType(), useLongTypeName);
                sb.append("[]");
            } else {
                sb.append(useLongTypeName ? type.getName() : type.getSimpleName());
            }
        }
    }

    private class SourceLocationImpl
    implements SourceLocation {
        private SourceLocationImpl() {
        }

        public Class getWithinType() {
            if (MethodInvocationProceedingJoinPoint.this.methodInvocation.getThis() == null) {
                throw new UnsupportedOperationException("No source location joinpoint available: target is null");
            }
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getThis().getClass();
        }

        public String getFileName() {
            throw new UnsupportedOperationException();
        }

        public int getLine() {
            throw new UnsupportedOperationException();
        }

        public int getColumn() {
            throw new UnsupportedOperationException();
        }
    }
}

