/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class FileServiceClient
extends MCSClient {
    private final Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(MultiPartFeature.class)).build();

    public FileServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public FileServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, null, username, password, 20000, 60000);
    }

    public FileServiceClient(String baseUrl, String authorizationHeader) {
        this(baseUrl, authorizationHeader, null, null, 20000, 60000);
    }

    public FileServiceClient(String baseUrl, String authorizationHeader, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        if (authorizationHeader != null) {
            this.client.register(new ECloudBasicAuthFilter(authorizationHeader));
        } else if (username != null || password != null) {
            this.client.register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        }
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getFile(String cloudId, String representationName, String version, String fileName) throws MCSException, IOException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName);
        Invocation.Builder requset = target.request();
        Response response = null;
        try {
            response = requset.get();
            InputStream inputStream = this.handleReadFileResponse(response);
            return inputStream;
        }
        finally {
            this.closeResponse(response);
        }
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName, String range) throws MCSException, IOException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName);
        Invocation.Builder request = target.request().header("Range", range);
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.PARTIAL_CONTENT.getStatusCode()) {
                InputStream contentResponse = response.readEntity(InputStream.class);
                InputStream inputStream = this.copiedInputStream(contentResponse);
                return inputStream;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getFile(String fileUrl) throws MCSException, IOException {
        Response response = null;
        try {
            response = this.client.target(fileUrl).request().get();
            InputStream inputStream = this.handleReadFileResponse(response);
            this.closeResponse(response);
            return inputStream;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getFile(String fileUrl, String key, String value) throws MCSException, IOException {
        Response response = null;
        try {
            response = this.client.target(fileUrl).request().header(key, value).get();
            InputStream inputStream = this.handleReadFileResponse(response);
            this.closeResponse(response);
            return inputStream;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI uploadFile(String cloudId, String representationName, String version, InputStream data, String mediaType, String expectedMd5) throws IOException, MCSException {
        URI uRI;
        Response response = null;
        FormDataMultiPart multipart = new FormDataMultiPart();
        try {
            WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version);
            multipart.field("mimeType", mediaType).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
            Invocation.Builder request = target.request();
            response = request.post(Entity.entity(multipart, multipart.getMediaType()));
            uRI = this.handleResponse(expectedMd5, response, Response.Status.CREATED.getStatusCode());
        }
        catch (Throwable throwable) {
            this.closeOpenResources(data, multipart, response);
            throw throwable;
        }
        this.closeOpenResources(data, multipart, response);
        return uRI;
    }

    public URI uploadFile(String cloudId, String representationName, String version, InputStream data, String mediaType) throws IOException, MCSException {
        Response response;
        block3: {
            URI uRI;
            response = null;
            FormDataMultiPart multipart = new FormDataMultiPart();
            try {
                WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version);
                multipart.field("mimeType", mediaType).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
                Invocation.Builder request = target.request();
                response = request.post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                uRI = response.getLocation();
            }
            catch (Throwable throwable) {
                this.closeOpenResources(data, multipart, response);
                throw throwable;
            }
            this.closeOpenResources(data, multipart, response);
            return uRI;
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String cloudId, String representationName, String version, String fileName, InputStream data, String mediaType) throws IOException, MCSException {
        Response response;
        block3: {
            URI uRI;
            response = null;
            FormDataMultiPart multipart = new FormDataMultiPart();
            try {
                WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version);
                multipart.field("mimeType", mediaType).field("fileName", fileName).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
                Invocation.Builder request = target.request();
                response = request.post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                uRI = response.getLocation();
            }
            catch (Throwable throwable) {
                this.closeOpenResources(data, multipart, response);
                throw throwable;
            }
            this.closeOpenResources(data, multipart, response);
            return uRI;
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    @Deprecated
    public URI uploadFile(String versionUrl, InputStream data, String mediaType) throws IOException, MCSException {
        Response response;
        block3: {
            URI uRI;
            String FILES_SEGMENT = "/files";
            response = null;
            FormDataMultiPart multipart = new FormDataMultiPart();
            try {
                multipart.field("mimeType", mediaType).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
                response = this.client.target(versionUrl + "/files").request().post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                uRI = response.getLocation();
            }
            catch (Throwable throwable) {
                this.closeOpenResources(data, multipart, response);
                throw throwable;
            }
            this.closeOpenResources(data, multipart, response);
            return uRI;
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI modyfiyFile(String cloudId, String representationName, String version, InputStream data, String mediaType, String fileName, String expectedMd5) throws IOException, MCSException {
        URI uRI;
        Response response = null;
        FormDataMultiPart multipart = new FormDataMultiPart();
        try {
            WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName);
            response = target.request().put(Entity.entity(data, mediaType));
            uRI = this.handleResponse(expectedMd5, response, Response.Status.NO_CONTENT.getStatusCode());
        }
        catch (Throwable throwable) {
            this.closeOpenResources(data, multipart, response);
            throw throwable;
        }
        this.closeOpenResources(data, multipart, response);
        return uRI;
    }

    public URI modifyFile(String fileUrl, InputStream data, String mediaType) throws IOException, MCSException {
        WebTarget target = this.client.target(fileUrl);
        FormDataMultiPart multipart = new FormDataMultiPart();
        Response response = null;
        try {
            response = target.request().put(Entity.entity(data, mediaType));
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                URI uRI = response.getLocation();
                return uRI;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeOpenResources(data, multipart, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String cloudId, String representationName, String version, String fileName) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName);
        Response response = null;
        try {
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public URI getFileUri(String cloudId, String representationName, String version, String fileName) {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName);
        return target.getUri();
    }

    public static Map<String, String> parseFileUri(String uri) {
        Pattern p = Pattern.compile(".*/records/([^/]+)/representations/([^/]+)/versions/([^/]+)/files/(.*)");
        Matcher m = p.matcher(uri);
        if (m.find()) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("cloudId", m.group(1));
            result.put("representationName", m.group(2));
            result.put("version", m.group(3));
            result.put("fileName", m.group(4));
            return result;
        }
        return null;
    }

    public void useAuthorizationHeader(String authorizationHeader) {
        this.client.register(new ECloudBasicAuthFilter(authorizationHeader));
    }

    public void close() {
        this.client.close();
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    private void closeOpenResources(InputStream data, FormDataMultiPart multipart, Response response) throws IOException {
        this.closeResponse(response);
        IOUtils.closeQuietly(data);
        multipart.close();
    }

    private URI handleResponse(String expectedMd5, Response response, int expectedStatusCode) throws IOException, MCSException {
        if (response.getStatus() == expectedStatusCode) {
            if (!expectedMd5.equals(response.getEntityTag().getValue())) {
                throw new IOException("Incorrect MD5 checksum");
            }
            return response.getLocation();
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    private InputStream handleReadFileResponse(Response response) throws IOException, MCSException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            InputStream contentResponse = response.readEntity(InputStream.class);
            return this.copiedInputStream(contentResponse);
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    private InputStream copiedInputStream(InputStream originIS) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = originIS.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        IOUtils.closeQuietly(originIS);
        return new ByteArrayInputStream(buffer.toByteArray());
    }
}

