/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model.dps;

import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TaskInfo {
    private static final int DEFAULT_PROGRESS_PERCENTAGE = -1;
    private long id;
    private String topologyName;
    private int expectedSize;
    private int processedElementCount;
    private int retryCount;
    private TaskState state;
    private String info;
    private String ownerId;
    private Date finishDate;
    private Date startDate;
    private Date sentDate;
    private int processedPercentage;
    private int errors;
    private String taskDefinition;
    private String topicName;
    private List<SubTaskInfo> subtasks = new ArrayList<SubTaskInfo>();

    public void setId(long id) {
        this.id = id;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public TaskInfo() {
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public void setSubtasks(List<SubTaskInfo> subtasks) {
        this.subtasks = subtasks;
    }

    public int getProcessedElementCount() {
        return this.processedElementCount;
    }

    public void setProcessedElementCount(int processedElementCount) {
        this.processedElementCount = processedElementCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getProcessedPercentage() {
        return this.processedPercentage;
    }

    public void setProcessedPercentage(int processedPercentage) {
        this.processedPercentage = processedPercentage;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    private void calculateProgress() {
        this.processedPercentage = this.expectedSize < 0 ? -1 : (this.expectedSize > 0 ? 100 * this.processedElementCount / this.expectedSize : 0);
    }

    public TaskInfo(long id, String topologyName, TaskState state, String info, Date sentDate, Date startDate, Date finishDate) {
        this(id, topologyName, state, info, 0, 0, 0, 0, sentDate, startDate, finishDate);
    }

    public TaskInfo(long id, String topologyName, TaskState state, String info, int containsElements, int processedElementCount, int retryCount, int errors, Date sentDate, Date startDate, Date finishDate) {
        this.id = id;
        this.topologyName = topologyName;
        this.state = state;
        this.info = info;
        this.expectedSize = containsElements;
        this.processedElementCount = processedElementCount;
        this.retryCount = retryCount;
        this.sentDate = sentDate;
        this.startDate = startDate;
        this.finishDate = finishDate;
        this.errors = errors;
        this.calculateProgress();
    }

    public long getId() {
        return this.id;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public void setExpectedSize(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    public List<SubTaskInfo> getSubtasks() {
        return Collections.unmodifiableList(this.subtasks);
    }

    public void addSubtask(SubTaskInfo subtask) {
        this.subtasks.add(subtask);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo taskInfo = (TaskInfo)o;
        if (this.expectedSize != taskInfo.expectedSize) {
            return false;
        }
        if (this.errors != taskInfo.errors) {
            return false;
        }
        if (this.processedPercentage != taskInfo.processedPercentage) {
            return false;
        }
        if (this.id != taskInfo.id) {
            return false;
        }
        if (this.subtasks != null ? !this.subtasks.equals(taskInfo.subtasks) : taskInfo.subtasks != null) {
            return false;
        }
        if (this.topologyName != null ? !this.topologyName.equals(taskInfo.topologyName) : taskInfo.topologyName != null) {
            return false;
        }
        if (this.state != taskInfo.state) {
            return false;
        }
        if (this.startDate == null && taskInfo.startDate != null) {
            return false;
        }
        if (this.startDate != null && taskInfo.startDate != null && this.startDate.getTime() != taskInfo.startDate.getTime()) {
            return false;
        }
        if (this.sentDate == null && taskInfo.sentDate != null) {
            return false;
        }
        if (this.sentDate != null && taskInfo.sentDate != null && this.sentDate.getTime() != taskInfo.sentDate.getTime()) {
            return false;
        }
        if (this.finishDate == null && taskInfo.finishDate != null) {
            return false;
        }
        if (this.finishDate != null && taskInfo.finishDate != null && this.finishDate.getTime() != taskInfo.finishDate.getTime()) {
            return false;
        }
        if (this.ownerId == null && taskInfo.ownerId != null) {
            return false;
        }
        if (this.ownerId != null && taskInfo.ownerId == null) {
            return false;
        }
        if (this.ownerId != null && !this.ownerId.equals(taskInfo.ownerId)) {
            return false;
        }
        return !(this.topicName != null ? !this.topicName.equals(taskInfo.topicName) : taskInfo.topicName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.topologyName != null ? this.topologyName.hashCode() : 0);
        result = 31 * result + this.expectedSize;
        result = 31 * result + this.errors;
        result = 31 * result + this.processedPercentage;
        result = 31 * result + (this.subtasks != null ? this.subtasks.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.sentDate != null ? this.sentDate.hashCode() : 0);
        result = 31 * result + (this.ownerId != null ? this.ownerId.hashCode() : 0);
        result = 31 * result + (this.topicName != null ? this.topicName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TaskInfo(id=" + this.getId() + ", topologyName=" + this.getTopologyName() + ", expectedSize=" + this.getExpectedSize() + ", processedElementCount=" + this.getProcessedElementCount() + ", retryCount=" + this.getRetryCount() + ", state=" + this.getState() + ", info=" + this.getInfo() + ", ownerId=" + this.getOwnerId() + ", finishDate=" + this.getFinishDate() + ", startDate=" + this.getStartDate() + ", sentDate=" + this.getSentDate() + ", processedPercentage=" + this.getProcessedPercentage() + ", errors=" + this.getErrors() + ", taskDefinition=" + this.getTaskDefinition() + ", topicName=" + this.getTopicName() + ", subtasks=" + this.getSubtasks() + ")";
    }
}

