/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.Permission;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.status.McsErrorCode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;

public class RecordServiceClient
extends MCSClient {
    private final Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(MultiPartFeature.class)).build();

    public RecordServiceClient(String baseUrl) {
        this(baseUrl, 20000, 60000);
    }

    public RecordServiceClient(String baseUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this(baseUrl, null, null, null, connectTimeoutInMillis, readTimeoutInMillis);
    }

    public RecordServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, null, username, password, 20000, 60000);
    }

    public RecordServiceClient(String baseUrl, String authorizationHeader) {
        this(baseUrl, authorizationHeader, null, null, 20000, 60000);
    }

    public RecordServiceClient(String baseUrl, String authorizationHeader, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        if (authorizationHeader != null) {
            this.client.register((Object)new ECloudBasicAuthFilter(authorizationHeader));
        } else if (username != null || password != null) {
            this.client.register((Object)HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        }
        this.client.property("jersey.config.client.connectTimeout", (Object)connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", (Object)readTimeoutInMillis);
    }

    public void useAuthorizationHeader(String authorizationHeader) {
        this.client.register((Object)new ECloudBasicAuthFilter(authorizationHeader));
    }

    public Record getRecord(String cloudId) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}").resolveTemplate("cloudId", (Object)cloudId);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                Record record = (Record)response.readEntity(Record.class);
                return record;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public void deleteRecord(String cloudId) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}").resolveTemplate("cloudId", (Object)cloudId);
        Invocation.Builder request = target.request();
        this.handleDeleteRequest(request);
    }

    public List<Representation> getRepresentations(String cloudId) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations").resolveTemplate("cloudId", (Object)cloudId);
        Response response = null;
        try {
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List list = (List)response.readEntity((GenericType)new GenericType<List<Representation>>(){});
                return list;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public Representation getRepresentation(String cloudId, String representationName) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode() || response.getStatus() == Response.Status.TEMPORARY_REDIRECT.getStatusCode()) {
                Representation representation = (Representation)response.readEntity(Representation.class);
                return representation;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName);
        Invocation.Builder request = target.request();
        Form form = new Form();
        form.param("providerId", providerId);
        Response response = null;
        return this.handleRepresentationResponse(form, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI createRepresentation(String cloudId, String representationName, String providerId, InputStream data, String fileName, String mediaType) throws IOException, MCSException {
        URI uRI;
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/files").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName);
        Invocation.Builder request = target.request();
        FormDataMultiPart multipart = null;
        Response response = null;
        request.header("Content-Type", (Object)"multipart/form-data");
        try {
            multipart = this.prepareRequestBody(providerId, data, fileName, mediaType);
            response = request.post(Entity.entity((Object)multipart, (String)"multipart/form-data"));
            uRI = this.handleResponse(response);
            this.closeResponse(response);
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            IOUtils.closeQuietly((InputStream)data);
            if (multipart != null) {
                multipart.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)data);
        if (multipart != null) {
            multipart.close();
        }
        return uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI createRepresentation(String cloudId, String representationName, String providerId, InputStream data, String fileName, String mediaType, String key, String value) throws IOException, MCSException {
        URI uRI;
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/files").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName);
        Invocation.Builder request = target.request();
        FormDataMultiPart multipart = null;
        Response response = null;
        request.header("Content-Type", (Object)"multipart/form-data");
        try {
            multipart = this.prepareRequestBody(providerId, data, fileName, mediaType);
            response = request.header(key, (Object)value).post(Entity.entity((Object)multipart, (String)"multipart/form-data"));
            uRI = this.handleResponse(response);
            this.closeResponse(response);
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            IOUtils.closeQuietly((InputStream)data);
            if (multipart != null) {
                multipart.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)data);
        if (multipart != null) {
            multipart.close();
        }
        return uRI;
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, InputStream data, String mediaType) throws IOException, MCSException {
        return this.createRepresentation(cloudId, representationName, providerId, data, null, mediaType);
    }

    private FormDataMultiPart prepareRequestBody(String providerId, InputStream data, String fileName, String mediaType) {
        FormDataMultiPart requestBody = new FormDataMultiPart();
        requestBody.field("providerId", providerId).field("mimeType", mediaType).bodyPart((BodyPart)new StreamDataBodyPart("data", data, "application/octet-stream"));
        if (fileName == null || !fileName.trim().isEmpty()) {
            fileName = UUID.randomUUID().toString();
        }
        requestBody.field("fileName", fileName);
        return requestBody;
    }

    public void deleteRepresentation(String cloudId, String representationName) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName);
        Invocation.Builder request = target.request();
        this.handleDeleteRequest(request);
    }

    public List<Representation> getRepresentations(String cloudId, String representationName) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List list = (List)response.readEntity((GenericType)new GenericType<List<Representation>>(){});
                return list;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public Representation getRepresentation(String cloudId, String representationName, String version) throws MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version);
        Invocation.Builder request = webtarget.request();
        return this.handleRepresentationResponse(webtarget, request);
    }

    public Representation getRepresentation(String cloudId, String representationName, String version, String key, String value) throws MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version);
        Invocation.Builder request = webtarget.request().header(key, (Object)value);
        return this.handleRepresentationResponse(webtarget, request);
    }

    public void deleteRepresentation(String cloudId, String representationName, String version) throws MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version);
        Invocation.Builder request = webtarget.request();
        this.handleDeleteRequest(request);
    }

    public void deleteRepresentation(String cloudId, String representationName, String version, String key, String value) throws MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version);
        Invocation.Builder request = webtarget.request().header(key, (Object)value);
        this.handleDeleteRequest(request);
    }

    public URI copyRepresentation(String cloudId, String representationName, String version) throws MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/copy").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version);
            Invocation.Builder request = target.request();
            response = null;
            try {
                response = request.post(Entity.entity((Object)new Form(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI persistRepresentation(String cloudId, String representationName, String version) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/persist").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version);
        Form form = new Form();
        Invocation.Builder request = target.request();
        Response response = null;
        return this.handleRepresentationResponse(form, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPermissionsToVersion(String cloudId, String representationName, String version, String userName, Permission permission) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/permissions/{permission}/users/{userName}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version).resolveTemplate("permission", (Object)permission.getValue()).resolveTemplate("userName", (Object)userName);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(null);
            if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                throw new MCSException("Permissions not modified");
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                this.throwException(response);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public void revokePermissionsToVersion(String cloudId, String representationName, String version, String userName, Permission permission) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/permissions/{permission}/users/{userName}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version).resolveTemplate("permission", (Object)permission.getValue()).resolveTemplate("userName", (Object)userName);
        Invocation.Builder request = target.request();
        this.handleDeleteRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void permitVersion(String cloudId, String representationName, String version) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/permit").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("version", (Object)version);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(null);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                this.throwException(response);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public List<Representation> getRepresentationsByRevision(String cloudId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp) throws MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/revisions/{revisionName}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("revisionName", (Object)revisionName);
        if (revisionProviderId == null) {
            throw new MCSException("RevisionProviderId is required");
        }
        webtarget = webtarget.queryParam("revisionProviderId", new Object[]{revisionProviderId});
        if (revisionTimestamp != null) {
            webtarget = webtarget.queryParam("revisionTimestamp", new Object[]{revisionTimestamp});
        }
        Invocation.Builder request = webtarget.request();
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List list = (List)response.readEntity((GenericType)new GenericType<List<Representation>>(){});
                return list;
            }
            try {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
            catch (MessageBodyProviderNotFoundException e) {
                String out = webtarget.getUri().toString();
                throw new MCSException(out, (Exception)((Object)e));
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public List<Representation> getRepresentationsByRevision(String cloudId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp, String key, String value) throws MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/revisions/{revisionName}").resolveTemplate("cloudId", (Object)cloudId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("revisionName", (Object)revisionName);
        if (revisionProviderId == null) {
            throw new MCSException("RevisionProviderId is required");
        }
        webtarget = webtarget.queryParam("revisionProviderId", new Object[]{revisionProviderId});
        if (revisionTimestamp != null) {
            webtarget = webtarget.queryParam("revisionTimestamp", new Object[]{revisionTimestamp});
        }
        Invocation.Builder request = webtarget.request().header(key, (Object)value);
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List list = (List)response.readEntity((GenericType)new GenericType<List<Representation>>(){});
                return list;
            }
            try {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
            catch (MessageBodyProviderNotFoundException e) {
                String out = webtarget.getUri().toString();
                throw new MCSException(out, (Exception)((Object)e));
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public void close() {
        this.client.close();
    }

    private void throwException(Response response) throws MCSException {
        try {
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        catch (MessageBodyProviderNotFoundException e) {
            ErrorInfo errorInfo = new ErrorInfo();
            errorInfo.setErrorCode(McsErrorCode.OTHER.toString());
            errorInfo.setDetails("Mcs not available");
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    private URI handleResponse(Response response) throws MCSException {
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return response.getLocation();
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeleteRequest(Invocation.Builder request) throws MCSException {
        Response response = null;
        try {
            response = request.delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    private Representation handleRepresentationResponse(WebTarget webtarget, Invocation.Builder request) throws MCSException {
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                Representation representation = (Representation)response.readEntity(Representation.class);
                return representation;
            }
            try {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
            catch (MessageBodyProviderNotFoundException e) {
                String out = webtarget.getUri().toString();
                throw new MCSException(out, (Exception)((Object)e));
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI handleRepresentationResponse(Form form, Invocation.Builder request, Response response) throws MCSException {
        try {
            response = request.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            URI uRI = this.handleResponse(response);
            return uRI;
        }
        finally {
            this.closeResponse(response);
        }
    }
}

