/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.CloudIdAndTimestampResponse;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.CloudTagsResponse;
import eu.europeana.cloud.common.response.CloudVersionRevisionResponse;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.mcs.driver.DataSetIterator;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.RepresentationIterator;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class DataSetServiceClient
extends MCSClient {
    private final Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(MultiPartFeature.class)).build();

    public DataSetServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public DataSetServiceClient(String baseUrl, String authorization) {
        this(baseUrl, authorization, null, null, 20000, 60000);
    }

    public DataSetServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, null, username, password, 20000, 60000);
    }

    public DataSetServiceClient(String baseUrl, String authorizationHeader, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        if (authorizationHeader != null) {
            this.client.register((Object)new ECloudBasicAuthFilter(authorizationHeader));
        } else if (username != null || password != null) {
            this.client.register((Object)HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        }
        this.client.property("jersey.config.client.connectTimeout", (Object)connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", (Object)readTimeoutInMillis);
    }

    public ResultSlice<DataSet> getDataSetsForProviderChunk(String providerId, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets").resolveTemplate("providerId", (Object)providerId);
        if (startFrom != null) {
            target = target.queryParam("startFrom", new Object[]{startFrom});
        }
        return this.prepareResultSliceResponse(target);
    }

    public List<DataSet> getDataSetsForProvider(String providerId) throws MCSException {
        ResultSlice<DataSet> resultSlice;
        ArrayList<DataSet> resultList = new ArrayList<DataSet>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetsForProviderChunk(providerId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public DataSetIterator getDataSetIteratorForProvider(String providerId) {
        return new DataSetIterator(this, providerId);
    }

    public URI createDataSet(String providerId, String dataSetId, String description) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets").resolveTemplate("providerId", (Object)providerId);
        Form form = new Form();
        form.param("dataSetId", dataSetId);
        form.param("description", description);
        try (Response response = null;){
            response = target.request().post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                URI uRI = response.getLocation();
                return uRI;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public ResultSlice<Representation> getDataSetRepresentationsChunk(String providerId, String dataSetId, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId);
        if (startFrom != null) {
            target = target.queryParam("startFrom", new Object[]{startFrom});
        }
        try (Response response = null;){
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = (ResultSlice)response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public List<Representation> getDataSetRepresentations(String providerId, String dataSetId) throws MCSException {
        ResultSlice<Representation> resultSlice;
        ArrayList<Representation> resultList = new ArrayList<Representation>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRepresentationsChunk(providerId, dataSetId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public RepresentationIterator getRepresentationIterator(String providerId, String dataSetId) {
        return new RepresentationIterator(this, providerId, dataSetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDescriptionOfDataSet(String providerId, String dataSetId, String description) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId);
        Form form = new Form();
        form.param("description", description);
        try (Response response = null;){
            response = target.request().put(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataSet(String providerId, String dataSetId) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId);
        try (Response response = null;){
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRepresentationToDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId);
        Form form = this.getForm(cloudId, representationName, version);
        try (Response response = null;){
            response = target.request().post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    private Form getForm(String cloudId, String representationName, String version) {
        Form form = new Form();
        form.param("cloudId", cloudId);
        form.param("representationName", representationName);
        form.param("version", version);
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRepresentationToDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version, String key, String value) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId);
        Form form = this.getForm(cloudId, representationName, version);
        try (Response response = null;){
            response = target.request().header(key, (Object)value).post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassignRepresentationFromDataSet(String providerId, String dataSetId, String cloudId, String representationName, String version) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/assignments").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId).queryParam("cloudId", new Object[]{cloudId}).queryParam("representationName", new Object[]{representationName}).queryParam("version", new Object[]{version});
        Response response = null;
        try {
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public ResultSlice<CloudTagsResponse> getDataSetRevisionsChunk(String providerId, String dataSetId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp, String startFrom, Integer limit) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/representations/{representationName}/revisions/{revisionName}/revisionProvider/{revisionProviderId}").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId).resolveTemplate("representationName", (Object)representationName).resolveTemplate("revisionName", (Object)revisionName).resolveTemplate("revisionProviderId", (Object)revisionProviderId).queryParam("revisionTimestamp", new Object[]{revisionTimestamp}).queryParam("startFrom", new Object[]{startFrom});
        target = target.queryParam("limit", new Object[]{limit != null ? limit : 0});
        Response response = null;
        try {
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = (ResultSlice)response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public List<CloudTagsResponse> getDataSetRevisions(String providerId, String dataSetId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp) throws MCSException {
        ResultSlice<CloudTagsResponse> resultSlice;
        ArrayList<CloudTagsResponse> resultList = new ArrayList<CloudTagsResponse>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRevisionsChunk(providerId, dataSetId, representationName, revisionName, revisionProviderId, revisionTimestamp, startFrom, null)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud ids and revision tags: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public ResultSlice<CloudVersionRevisionResponse> getDataSetCloudIdsByRepresentationChunk(String dataSetId, String providerId, String representationName, String dateFrom, String tag, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/representations/{representationName}").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId).resolveTemplate("representationName", (Object)representationName).queryParam("creationDateFrom", new Object[]{dateFrom}).queryParam("tag", new Object[]{tag});
        if (startFrom != null) {
            target = target.queryParam("startFrom", new Object[]{startFrom});
        }
        return this.prepareResultSliceResponse(target);
    }

    public List<CloudVersionRevisionResponse> getDataSetCloudIdsByRepresentation(String dataSetId, String providerId, String representationName, String dateFrom, String tag) throws MCSException {
        ResultSlice<CloudVersionRevisionResponse> resultSlice;
        ArrayList<CloudVersionRevisionResponse> resultList = new ArrayList<CloudVersionRevisionResponse>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetCloudIdsByRepresentationChunk(dataSetId, providerId, representationName, dateFrom, tag, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud identifiers from data set: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public ResultSlice<CloudIdAndTimestampResponse> getLatestDataSetCloudIdByRepresentationAndRevisionChunk(String dataSetId, String providerId, String revisionProvider, String revisionName, String representationName, Boolean isDeleted, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/revision/{revisionName}/revisionProvider/{revisionProvider}/representations/{representationName}").resolveTemplate("providerId", (Object)providerId).resolveTemplate("revisionName", (Object)revisionName).resolveTemplate("revisionProvider", (Object)revisionProvider).resolveTemplate("dataSetId", (Object)dataSetId).resolveTemplate("representationName", (Object)representationName);
        if (startFrom != null) {
            target = target.queryParam("startFrom", new Object[]{startFrom});
        }
        if (isDeleted != null) {
            target = target.queryParam("deleted", new Object[]{isDeleted});
        }
        return this.prepareResultSliceResponse(target);
    }

    public List<CloudIdAndTimestampResponse> getLatestDataSetCloudIdByRepresentationAndRevision(String dataSetId, String providerId, String revisionProvider, String revisionName, String representationName, Boolean isDeleted) throws MCSException {
        ResultSlice<CloudIdAndTimestampResponse> resultSlice;
        ArrayList<CloudIdAndTimestampResponse> resultList = new ArrayList<CloudIdAndTimestampResponse>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getLatestDataSetCloudIdByRepresentationAndRevisionChunk(dataSetId, providerId, revisionProvider, revisionName, representationName, isDeleted, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud identifiers from data set: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public String getLatelyTaggedRecords(String dataSetId, String providerId, String cloudId, String representationName, String revisionName, String revisionProviderId) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path("/data-providers/{providerId}/data-sets/{dataSetId}/latelyRevisionedVersion").resolveTemplate("providerId", (Object)providerId).resolveTemplate("dataSetId", (Object)dataSetId).queryParam("cloudId", new Object[]{cloudId}).queryParam("representationName", new Object[]{representationName}).queryParam("revisionName", new Object[]{revisionName}).queryParam("revisionProviderId", new Object[]{revisionProviderId});
        try (Response response = null;){
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                String string = (String)response.readEntity(String.class);
                return string;
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                String string = null;
                return string;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register((Object)new ECloudBasicAuthFilter(headerValue));
    }

    public void close() {
        this.client.close();
    }

    private ResultSlice prepareResultSliceResponse(WebTarget target) throws MCSException {
        try (Response response = null;){
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = (ResultSlice)response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }
}

