/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMapTransactionAttributeSource
implements TransactionAttributeSource,
BeanClassLoaderAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, TransactionAttribute> methodMap;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean eagerlyInitialized = false;
    private boolean initialized = false;
    private final Map<Method, TransactionAttribute> transactionAttributeMap = new HashMap<Method, TransactionAttribute>();
    private final Map<Method, String> methodNameMap = new HashMap<Method, String>();

    public void setMethodMap(Map<String, TransactionAttribute> methodMap) {
        this.methodMap = methodMap;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    public void afterPropertiesSet() {
        this.initMethodMap(this.methodMap);
        this.eagerlyInitialized = true;
        this.initialized = true;
    }

    protected void initMethodMap(Map<String, TransactionAttribute> methodMap) {
        if (methodMap != null) {
            for (Map.Entry<String, TransactionAttribute> entry : methodMap.entrySet()) {
                this.addTransactionalMethod(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addTransactionalMethod(String name, TransactionAttribute attr) {
        Assert.notNull((Object)name, "Name must not be null");
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex == -1) {
            throw new IllegalArgumentException("'" + name + "' is not a valid method name: format is FQN.methodName");
        }
        String className = name.substring(0, lastDotIndex);
        String methodName = name.substring(lastDotIndex + 1);
        Class<?> clazz = ClassUtils.resolveClassName(className, this.beanClassLoader);
        this.addTransactionalMethod(clazz, methodName, attr);
    }

    public void addTransactionalMethod(Class<?> clazz, String mappedName, TransactionAttribute attr) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)mappedName, "Mapped name must not be null");
        String name = String.valueOf(clazz.getName()) + '.' + mappedName;
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isMatch(method.getName(), mappedName)) {
                matchingMethods.add(method);
            }
            ++n2;
        }
        if (matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find method '" + mappedName + "' on class [" + clazz.getName() + "]");
        }
        for (Method method : matchingMethods) {
            String regMethodName = this.methodNameMap.get(method);
            if (regMethodName == null || !regMethodName.equals(name) && regMethodName.length() <= name.length()) {
                if (this.logger.isDebugEnabled() && regMethodName != null) {
                    this.logger.debug((Object)("Replacing attribute for transactional method [" + method + "]: current name '" + name + "' is more specific than '" + regMethodName + "'"));
                }
                this.methodNameMap.put(method, name);
                this.addTransactionalMethod(method, attr);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Keeping attribute for transactional method [" + method + "]: current name '" + name + "' is not more specific than '" + regMethodName + "'"));
        }
    }

    public void addTransactionalMethod(Method method, TransactionAttribute attr) {
        Assert.notNull((Object)method, "Method must not be null");
        Assert.notNull((Object)attr, "TransactionAttribute must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding transactional method [" + method + "] with attribute [" + attr + "]"));
        }
        this.transactionAttributeMap.put(method, attr);
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionAttribute getTransactionAttribute(Method method, Class<?> targetClass) {
        if (this.eagerlyInitialized) {
            return this.transactionAttributeMap.get(method);
        }
        Map<Method, TransactionAttribute> map = this.transactionAttributeMap;
        synchronized (map) {
            if (!this.initialized) {
                this.initMethodMap(this.methodMap);
                this.initialized = true;
            }
            return this.transactionAttributeMap.get(method);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodMapTransactionAttributeSource)) {
            return false;
        }
        MethodMapTransactionAttributeSource otherTas = (MethodMapTransactionAttributeSource)other;
        return ObjectUtils.nullSafeEquals(this.methodMap, otherTas.methodMap);
    }

    public int hashCode() {
        return MethodMapTransactionAttributeSource.class.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.methodMap;
    }
}

