/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.rcp;

import java.util.Collection;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.rcp.RemoteAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private RemoteAuthenticationManager remoteAuthenticationManager;

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.remoteAuthenticationManager, "remoteAuthenticationManager is mandatory");
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getPrincipal().toString();
        Object credentials = authentication.getCredentials();
        String password = credentials == null ? null : credentials.toString();
        Collection<? extends GrantedAuthority> authorities = this.remoteAuthenticationManager.attemptAuthentication(username, password);
        return new UsernamePasswordAuthenticationToken(username, password, authorities);
    }

    public RemoteAuthenticationManager getRemoteAuthenticationManager() {
        return this.remoteAuthenticationManager;
    }

    public void setRemoteAuthenticationManager(RemoteAuthenticationManager remoteAuthenticationManager) {
        this.remoteAuthenticationManager = remoteAuthenticationManager;
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

