/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.net.httpclient;

import com.eaio.net.httpclient.CountingEntity;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingInterceptor
implements HttpRequestInterceptor,
HttpResponseInterceptor {
    private static final String STOP_WATCH = "stop_watch";
    private static final String COUNTING_ENTITY = "counting_entity";
    private Logger log = LoggerFactory.getLogger(TimingInterceptor.class);

    public void process(HttpRequest request, HttpContext context) {
        if (context != null) {
            StopWatch watch = new StopWatch();
            context.setAttribute(STOP_WATCH, (Object)watch);
            watch.start();
        }
    }

    public void process(HttpResponse response, HttpContext context) {
        HttpEntity entity;
        if (context != null && (entity = response.getEntity()) != null) {
            CountingEntity countingEntity = new CountingEntity(response.getEntity());
            context.setAttribute(COUNTING_ENTITY, (Object)countingEntity);
            response.setEntity((HttpEntity)countingEntity);
        }
    }

    public static long getByteCount(HttpContext context) {
        CountingEntity countingEntity;
        long out = -1L;
        if (context != null && (countingEntity = (CountingEntity)((Object)context.getAttribute(COUNTING_ENTITY))) != null) {
            out = countingEntity.getByteCount();
        }
        return out;
    }

    public static long getStartTime(HttpContext context) {
        StopWatch watch;
        long out = -1L;
        if (context != null && (watch = (StopWatch)context.getAttribute(STOP_WATCH)) != null) {
            out = watch.getStartTime();
        }
        return out;
    }

    public static long getTime(HttpContext context) {
        StopWatch watch;
        long out = -1L;
        if (context != null && (watch = (StopWatch)context.getAttribute(STOP_WATCH)) != null) {
            out = watch.getTime();
        }
        return out;
    }

    public static void log(HttpContext context, Logger log) {
        TimingInterceptor.log(context, log, TimingInterceptor.getTime(context), TimingInterceptor.getByteCount(context));
    }

    static void log(HttpContext context, Logger log, long time, long byteCount) {
        if (context != null && time >= 0L && byteCount >= 0L) {
            String target = TimingInterceptor.getURL(context);
            String host = URI.create(target).getHost();
            long bytesPerSecond = Math.round((double)byteCount * (1000.0 / (double)time));
            log.info("request to {} on {} took {} ms at {}/s transfer {} B {}", target, host, time, FileUtils.byteCountToDisplaySize(bytesPerSecond), byteCount, FileUtils.byteCountToDisplaySize(byteCount));
        }
    }

    static String getURL(HttpContext context) {
        HttpUriRequest currentReq = (HttpUriRequest)context.getAttribute("http.request");
        HttpHost currentHost = (HttpHost)context.getAttribute("http.target_host");
        String currentUrl = currentReq.getURI().isAbsolute() ? currentReq.getURI().toString() : String.valueOf(currentHost.toURI()) + currentReq.getURI();
        return currentUrl;
    }
}

