/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.header;

import org.springframework.security.web.server.header.ServerHttpHeadersWriter;
import org.springframework.security.web.server.header.StaticServerHttpHeadersWriter;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class XXssProtectionServerHttpHeadersWriter
implements ServerHttpHeadersWriter {
    public static final String X_XSS_PROTECTION = "X-XSS-Protection";
    private ServerHttpHeadersWriter delegate;
    private HeaderValue headerValue = HeaderValue.DISABLED;

    public XXssProtectionServerHttpHeadersWriter() {
        this.updateDelegate();
    }

    @Override
    public Mono<Void> writeHttpHeaders(ServerWebExchange exchange) {
        return this.delegate.writeHttpHeaders(exchange);
    }

    public void setHeaderValue(HeaderValue headerValue) {
        Assert.notNull((Object)headerValue, "headerValue cannot be null");
        this.headerValue = headerValue;
        this.updateDelegate();
    }

    private void updateDelegate() {
        StaticServerHttpHeadersWriter.Builder builder = StaticServerHttpHeadersWriter.builder();
        builder.header(X_XSS_PROTECTION, this.headerValue.toString());
        this.delegate = builder.build();
    }

    public static enum HeaderValue {
        DISABLED("0"),
        ENABLED("1"),
        ENABLED_MODE_BLOCK("1; mode=block");

        private final String value;

        private HeaderValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

