/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HttpStatusServerEntryPoint
implements ServerAuthenticationEntryPoint {
    private final HttpStatus httpStatus;

    public HttpStatusServerEntryPoint(HttpStatus httpStatus) {
        Assert.notNull((Object)httpStatus, "httpStatus cannot be null");
        this.httpStatus = httpStatus;
    }

    @Override
    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException authException) {
        return Mono.fromRunnable(() -> exchange.getResponse().setStatusCode((HttpStatusCode)this.httpStatus));
    }
}

