/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.firewall;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.springframework.util.Assert;

class FirewalledResponse
extends HttpServletResponseWrapper {
    private static final String LOCATION_HEADER = "Location";
    private static final String SET_COOKIE_HEADER = "Set-Cookie";

    FirewalledResponse(HttpServletResponse response) {
        super(response);
    }

    public void sendRedirect(String location) throws IOException {
        this.validateCrlf(LOCATION_HEADER, location);
        super.sendRedirect(location);
    }

    public void setHeader(String name, String value) {
        this.validateCrlf(name, value);
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.validateCrlf(name, value);
        super.addHeader(name, value);
    }

    public void addCookie(Cookie cookie) {
        if (cookie != null) {
            this.validateCrlf(SET_COOKIE_HEADER, cookie.getName());
            this.validateCrlf(SET_COOKIE_HEADER, cookie.getValue());
            this.validateCrlf(SET_COOKIE_HEADER, cookie.getPath());
            this.validateCrlf(SET_COOKIE_HEADER, cookie.getDomain());
            this.validateCrlf(SET_COOKIE_HEADER, cookie.getComment());
        }
        super.addCookie(cookie);
    }

    void validateCrlf(String name, String value) {
        Assert.isTrue(!this.hasCrlf(name) && !this.hasCrlf(value), () -> "Invalid characters (CR/LF) in header " + name);
    }

    private boolean hasCrlf(String value) {
        return value != null && (value.indexOf(10) != -1 || value.indexOf(13) != -1);
    }
}

