/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TokenBasedRememberMeServices
extends AbstractRememberMeServices {
    private static final RememberMeTokenAlgorithm DEFAULT_MATCHING_ALGORITHM = RememberMeTokenAlgorithm.SHA256;
    private static final RememberMeTokenAlgorithm DEFAULT_ENCODING_ALGORITHM = RememberMeTokenAlgorithm.SHA256;
    private final RememberMeTokenAlgorithm encodingAlgorithm;
    private RememberMeTokenAlgorithm matchingAlgorithm = DEFAULT_MATCHING_ALGORITHM;

    public TokenBasedRememberMeServices(String key, UserDetailsService userDetailsService) {
        this(key, userDetailsService, DEFAULT_ENCODING_ALGORITHM);
    }

    public TokenBasedRememberMeServices(String key, UserDetailsService userDetailsService, RememberMeTokenAlgorithm encodingAlgorithm) {
        super(key, userDetailsService);
        Assert.notNull((Object)encodingAlgorithm, "encodingAlgorithm cannot be null");
        this.encodingAlgorithm = encodingAlgorithm;
    }

    @Override
    protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        String expectedTokenSignature;
        if (!this.isValidCookieTokensLength(cookieTokens)) {
            throw new InvalidCookieException("Cookie token did not contain 3 or 4 tokens, but contained '" + Arrays.asList(cookieTokens) + "'");
        }
        long tokenExpiryTime = this.getTokenExpiryTime(cookieTokens);
        if (this.isTokenExpired(tokenExpiryTime)) {
            throw new InvalidCookieException("Cookie token[1] has expired (expired on '" + new Date(tokenExpiryTime) + "'; current time is '" + new Date() + "')");
        }
        UserDetails userDetails = this.getUserDetailsService().loadUserByUsername(cookieTokens[0]);
        Assert.notNull((Object)userDetails, () -> "UserDetailsService " + this.getUserDetailsService() + " returned null for username " + cookieTokens[0] + ". This is an interface contract violation");
        String actualTokenSignature = cookieTokens[2];
        RememberMeTokenAlgorithm actualAlgorithm = this.matchingAlgorithm;
        if (cookieTokens.length == 4) {
            actualTokenSignature = cookieTokens[3];
            actualAlgorithm = RememberMeTokenAlgorithm.valueOf(cookieTokens[2]);
        }
        if (!TokenBasedRememberMeServices.equals(expectedTokenSignature = this.makeTokenSignature(tokenExpiryTime, userDetails.getUsername(), userDetails.getPassword(), actualAlgorithm), actualTokenSignature)) {
            throw new InvalidCookieException("Cookie contained signature '" + actualTokenSignature + "' but expected '" + expectedTokenSignature + "'");
        }
        return userDetails;
    }

    private boolean isValidCookieTokensLength(String[] cookieTokens) {
        return cookieTokens.length == 3 || cookieTokens.length == 4;
    }

    private long getTokenExpiryTime(String[] cookieTokens) {
        try {
            return Long.valueOf(cookieTokens[1]);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidCookieException("Cookie token[1] did not contain a valid number (contained '" + cookieTokens[1] + "')");
        }
    }

    protected String makeTokenSignature(long tokenExpiryTime, String username, String password) {
        String data = username + ":" + tokenExpiryTime + ":" + password + ":" + this.getKey();
        try {
            MessageDigest digest = MessageDigest.getInstance(this.encodingAlgorithm.getDigestAlgorithm());
            return new String(Hex.encode(digest.digest(data.getBytes())));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("No " + this.encodingAlgorithm.name() + " algorithm available!");
        }
    }

    protected String makeTokenSignature(long tokenExpiryTime, String username, String password, RememberMeTokenAlgorithm algorithm) {
        String data = username + ":" + tokenExpiryTime + ":" + password + ":" + this.getKey();
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm.getDigestAlgorithm());
            return new String(Hex.encode(digest.digest(data.getBytes())));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("No " + algorithm.name() + " algorithm available!");
        }
    }

    protected boolean isTokenExpired(long tokenExpiryTime) {
        return tokenExpiryTime < System.currentTimeMillis();
    }

    @Override
    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        UserDetails user;
        String username = this.retrieveUserName(successfulAuthentication);
        String password = this.retrievePassword(successfulAuthentication);
        if (!StringUtils.hasLength(username)) {
            this.logger.debug("Unable to retrieve username");
            return;
        }
        if (!StringUtils.hasLength(password) && !StringUtils.hasLength(password = (user = this.getUserDetailsService().loadUserByUsername(username)).getPassword())) {
            this.logger.debug("Unable to obtain password for user: " + username);
            return;
        }
        int tokenLifetime = this.calculateLoginLifetime(request, successfulAuthentication);
        long expiryTime = System.currentTimeMillis();
        String signatureValue = this.makeTokenSignature(expiryTime += 1000L * (long)(tokenLifetime < 0 ? 1209600 : tokenLifetime), username, password, this.encodingAlgorithm);
        this.setCookie(new String[]{username, Long.toString(expiryTime), this.encodingAlgorithm.name(), signatureValue}, tokenLifetime, request, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added remember-me cookie for user '" + username + "', expiry: '" + new Date(expiryTime) + "'");
        }
    }

    public void setMatchingAlgorithm(RememberMeTokenAlgorithm matchingAlgorithm) {
        Assert.notNull((Object)matchingAlgorithm, "matchingAlgorithm cannot be null");
        this.matchingAlgorithm = matchingAlgorithm;
    }

    protected int calculateLoginLifetime(HttpServletRequest request, Authentication authentication) {
        return this.getTokenValiditySeconds();
    }

    protected String retrieveUserName(Authentication authentication) {
        if (this.isInstanceOfUserDetails(authentication)) {
            return ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return authentication.getPrincipal().toString();
    }

    protected String retrievePassword(Authentication authentication) {
        if (this.isInstanceOfUserDetails(authentication)) {
            return ((UserDetails)authentication.getPrincipal()).getPassword();
        }
        if (authentication.getCredentials() != null) {
            return authentication.getCredentials().toString();
        }
        return null;
    }

    private boolean isInstanceOfUserDetails(Authentication authentication) {
        return authentication.getPrincipal() instanceof UserDetails;
    }

    private static boolean equals(String expected, String actual) {
        byte[] expectedBytes = TokenBasedRememberMeServices.bytesUtf8(expected);
        byte[] actualBytes = TokenBasedRememberMeServices.bytesUtf8(actual);
        return MessageDigest.isEqual(expectedBytes, actualBytes);
    }

    private static byte[] bytesUtf8(String s) {
        return s != null ? Utf8.encode(s) : null;
    }

    public static enum RememberMeTokenAlgorithm {
        MD5("MD5"),
        SHA256("SHA-256");

        private final String digestAlgorithm;

        private RememberMeTokenAlgorithm(String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
        }

        public String getDigestAlgorithm() {
            return this.digestAlgorithm;
        }
    }
}

