/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;

abstract class MethodConfigUtils {
    MethodConfigUtils() {
    }

    static void registerDefaultMethodAccessManagerIfNecessary(ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("org.springframework.security.defaultMethodAccessManager")) {
            parserContext.getRegistry().registerBeanDefinition("org.springframework.security.defaultMethodAccessManager", MethodConfigUtils.createAccessManagerBean(RoleVoter.class, AuthenticatedVoter.class));
        }
    }

    private static RootBeanDefinition createAccessManagerBean(Class<? extends AccessDecisionVoter> ... voters) {
        ManagedList<RootBeanDefinition> defaultVoters = new ManagedList<RootBeanDefinition>(voters.length);
        for (Class<? extends AccessDecisionVoter> voter : voters) {
            defaultVoters.add(new RootBeanDefinition(voter));
        }
        BeanDefinitionBuilder accessMgrBuilder = BeanDefinitionBuilder.rootBeanDefinition(AffirmativeBased.class);
        accessMgrBuilder.addConstructorArgValue(defaultVoters);
        return (RootBeanDefinition)accessMgrBuilder.getBeanDefinition();
    }
}

