/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import java.io.IOException;
import java.net.ServerSocket;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.server.EmbeddedLdapServerContainer;
import org.springframework.security.ldap.server.UnboundIdContainer;
import org.springframework.util.ClassUtils;

public class EmbeddedLdapServerContextSourceFactoryBean
implements FactoryBean<DefaultSpringSecurityContextSource>,
DisposableBean,
ApplicationContextAware {
    private static final String UNBOUNDID_CLASSNAME = "com.unboundid.ldap.listener.InMemoryDirectoryServer";
    private static final boolean unboundIdPresent;
    private static final int DEFAULT_PORT = 33389;
    private static final int RANDOM_PORT = 0;
    private Integer port;
    private String ldif = "classpath*:*.ldif";
    private String root = "dc=springframework,dc=org";
    private ApplicationContext context;
    private String managerDn;
    private String managerPassword;
    private EmbeddedLdapServerContainer container;

    public static EmbeddedLdapServerContextSourceFactoryBean fromEmbeddedLdapServer() {
        return new EmbeddedLdapServerContextSourceFactoryBean();
    }

    public void setLdif(String ldif) {
        this.ldif = ldif;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setManagerDn(String managerDn) {
        this.managerDn = managerDn;
    }

    public void setManagerPassword(String managerPassword) {
        this.managerPassword = managerPassword;
    }

    @Override
    public DefaultSpringSecurityContextSource getObject() throws Exception {
        if (!unboundIdPresent) {
            throw new IllegalStateException("Embedded LDAP server is not provided");
        }
        this.container = this.getContainer();
        this.port = this.container.getPort();
        DefaultSpringSecurityContextSource contextSourceFromProviderUrl = new DefaultSpringSecurityContextSource("ldap://127.0.0.1:" + this.port + "/" + this.root);
        if (this.managerDn != null) {
            contextSourceFromProviderUrl.setUserDn(this.managerDn);
            if (this.managerPassword == null) {
                throw new IllegalStateException("managerPassword is required if managerDn is supplied");
            }
            contextSourceFromProviderUrl.setPassword(this.managerPassword);
        }
        contextSourceFromProviderUrl.afterPropertiesSet();
        return contextSourceFromProviderUrl;
    }

    @Override
    public Class<?> getObjectType() {
        return DefaultSpringSecurityContextSource.class;
    }

    @Override
    public void destroy() {
        if (this.container instanceof Lifecycle) {
            ((Lifecycle)this.container).stop();
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    private EmbeddedLdapServerContainer getContainer() {
        if (!unboundIdPresent) {
            throw new IllegalStateException("Embedded LDAP server is not provided");
        }
        UnboundIdContainer unboundIdContainer = new UnboundIdContainer(this.root, this.ldif);
        unboundIdContainer.setApplicationContext(this.context);
        unboundIdContainer.setPort(this.getEmbeddedServerPort());
        unboundIdContainer.afterPropertiesSet();
        return unboundIdContainer;
    }

    private int getEmbeddedServerPort() {
        if (this.port == null) {
            this.port = this.getDefaultEmbeddedServerPort();
        }
        return this.port;
    }

    private int getDefaultEmbeddedServerPort() {
        int n;
        ServerSocket serverSocket = new ServerSocket(33389);
        try {
            n = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return 0;
            }
        }
        serverSocket.close();
        return n;
    }

    static {
        ClassLoader classLoader = EmbeddedLdapServerContextSourceFactoryBean.class.getClassLoader();
        unboundIdPresent = ClassUtils.isPresent(UNBOUNDID_CLASSNAME, classLoader);
    }
}

