/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutAuthentication;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.oidc.session.InMemoryOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionInformation;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

final class OidcBackChannelLogoutHandler
implements LogoutHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private OidcSessionRegistry sessionRegistry = new InMemoryOidcSessionRegistry();
    private RestOperations restOperations = new RestTemplate();
    private String logoutEndpointName = "/logout";
    private String sessionCookieName = "JSESSIONID";
    private final OAuth2ErrorHttpMessageConverter errorHttpMessageConverter = new OAuth2ErrorHttpMessageConverter();

    OidcBackChannelLogoutHandler() {
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (!(authentication instanceof OidcBackChannelLogoutAuthentication)) {
            if (this.logger.isDebugEnabled()) {
                String message = "Did not perform OIDC Back-Channel Logout since authentication [%s] was of the wrong type";
                this.logger.debug(String.format(message, authentication.getClass().getSimpleName()));
            }
            return;
        }
        OidcBackChannelLogoutAuthentication token = (OidcBackChannelLogoutAuthentication)authentication;
        Iterable sessions = this.sessionRegistry.removeSessionInformation(token.getPrincipal());
        ArrayList<String> errors = new ArrayList<String>();
        int totalCount = 0;
        int invalidatedCount = 0;
        for (OidcSessionInformation session : sessions) {
            ++totalCount;
            try {
                this.eachLogout(request, session);
                ++invalidatedCount;
            }
            catch (RestClientException ex) {
                this.logger.debug("Failed to invalidate session", ex);
                errors.add(ex.getMessage());
                this.sessionRegistry.saveSessionInformation(session);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Invalidated %d out of %d sessions", invalidatedCount, totalCount));
        }
        if (!errors.isEmpty()) {
            this.handleLogoutFailure(response, this.oauth2Error(errors));
        }
    }

    private void eachLogout(HttpServletRequest request, OidcSessionInformation session) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cookie", this.sessionCookieName + "=" + session.getSessionId());
        for (Map.Entry credential : session.getAuthorities().entrySet()) {
            headers.add((String)credential.getKey(), (String)credential.getValue());
        }
        String logout = this.computeLogoutEndpoint(request);
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        this.restOperations.postForEntity(logout, (Object)entity, Object.class, new Object[0]);
    }

    String computeLogoutEndpoint(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return UriComponentsBuilder.fromHttpUrl((String)url).host("localhost").replacePath(this.logoutEndpointName).build().toUriString();
    }

    private OAuth2Error oauth2Error(Collection<String> errors) {
        return new OAuth2Error("partial_logout", "not all sessions were terminated: " + errors, "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
    }

    private void handleLogoutFailure(HttpServletResponse response, OAuth2Error error) {
        response.setStatus(400);
        try {
            this.errorHttpMessageConverter.write((Object)error, null, (HttpOutputMessage)new ServletServerHttpResponse(response));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void setSessionRegistry(OidcSessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, "sessionRegistry cannot be null");
        this.sessionRegistry = sessionRegistry;
    }

    void setRestOperations(RestOperations restOperations) {
        Assert.notNull((Object)restOperations, "restOperations cannot be null");
        this.restOperations = restOperations;
    }

    void setLogoutUri(String logoutUri) {
        Assert.hasText(logoutUri, "logoutUri cannot be empty");
        this.logoutEndpointName = logoutUri;
    }

    void setSessionCookieName(String sessionCookieName) {
        Assert.hasText(sessionCookieName, "clientSessionCookieName cannot be empty");
        this.sessionCookieName = sessionCookieName;
    }
}

