/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.DefaultSecurityFilterChain;

public abstract class AbstractHttpConfigurer<T extends AbstractHttpConfigurer<T, B>, B extends HttpSecurityBuilder<B>>
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, B> {
    private SecurityContextHolderStrategy securityContextHolderStrategy;

    public B disable() {
        ((HttpSecurityBuilder)this.getBuilder()).removeConfigurer(this.getClass());
        return (B)((HttpSecurityBuilder)this.getBuilder());
    }

    public T withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return (T)this;
    }

    protected SecurityContextHolderStrategy getSecurityContextHolderStrategy() {
        if (this.securityContextHolderStrategy != null) {
            return this.securityContextHolderStrategy;
        }
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(SecurityContextHolderStrategy.class);
        this.securityContextHolderStrategy = names.length == 1 ? context.getBean(SecurityContextHolderStrategy.class) : SecurityContextHolder.getContextHolderStrategy();
        return this.securityContextHolderStrategy;
    }
}

