/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherDsl;
import org.springframework.security.config.annotation.web.AuthorizeHttpRequestsDsl;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001c\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ,\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010#\u001a\u00020$2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ#\u0010%\u001a\u0018\u0012\u000e\u0012\f0'R\b\u0012\u0004\u0012\u00020)0(\u0012\u0004\u0012\u00020\u001d0&H\u0000\u00a2\u0006\u0002\b*J%\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040-\"\u00020\u0004\u00a2\u0006\u0002\u0010.J%\u0010/\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040-\"\u00020\u0004\u00a2\u0006\u0002\u0010.J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00102\u001a\u00020\u0004J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00104\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00065"}, d2={"Lorg/springframework/security/config/annotation/web/AuthorizeHttpRequestsDsl;", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl;", "()V", "HANDLER_MAPPING_INTROSPECTOR", "", "HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME", "MVC_PRESENT", "", "PATTERN_TYPE", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl$PatternType;", "authenticated", "Lorg/springframework/security/authorization/AuthorizationManager;", "Lorg/springframework/security/web/access/intercept/RequestAuthorizationContext;", "getAuthenticated", "()Lorg/springframework/security/authorization/AuthorizationManager;", "authorizationRules", "", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl$AuthorizationManagerRule;", "denyAll", "getDenyAll", "permitAll", "getPermitAll", "shouldFilterAllDispatcherTypes", "getShouldFilterAllDispatcherTypes", "()Ljava/lang/Boolean;", "setShouldFilterAllDispatcherTypes", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "authorize", "", "pattern", "servletPath", "access", "method", "Lorg/springframework/http/HttpMethod;", "matches", "Lorg/springframework/security/web/util/matcher/RequestMatcher;", "get", "Lkotlin/Function1;", "Lorg/springframework/security/config/annotation/web/configurers/AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry;", "Lorg/springframework/security/config/annotation/web/configurers/AuthorizeHttpRequestsConfigurer;", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "get$spring_security_config", "hasAnyAuthority", "authorities", "", "([Ljava/lang/String;)Lorg/springframework/security/authorization/AuthorizationManager;", "hasAnyRole", "roles", "hasAuthority", "authority", "hasRole", "role", "spring-security-config"})
public final class AuthorizeHttpRequestsDsl
extends AbstractRequestMatcherDsl {
    @Nullable
    private Boolean shouldFilterAllDispatcherTypes;
    @NotNull
    private final List<AbstractRequestMatcherDsl.AuthorizationManagerRule> authorizationRules = new ArrayList();
    @NotNull
    private final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME;
    @NotNull
    private final String HANDLER_MAPPING_INTROSPECTOR;
    private final boolean MVC_PRESENT = ClassUtils.isPresent(this.HANDLER_MAPPING_INTROSPECTOR, AuthorizeHttpRequestsDsl.class.getClassLoader());
    @NotNull
    private final AbstractRequestMatcherDsl.PatternType PATTERN_TYPE = this.MVC_PRESENT ? AbstractRequestMatcherDsl.PatternType.MVC : AbstractRequestMatcherDsl.PatternType.ANT;
    @NotNull
    private final AuthorizationManager<RequestAuthorizationContext> permitAll = AuthorizeHttpRequestsDsl::permitAll$lambda$0;
    @NotNull
    private final AuthorizationManager<RequestAuthorizationContext> denyAll = AuthorizeHttpRequestsDsl::denyAll$lambda$1;
    @NotNull
    private final AuthorizationManager<RequestAuthorizationContext> authenticated;

    public AuthorizeHttpRequestsDsl() {
        this.HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
        this.HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
        AuthenticatedAuthorizationManager authenticatedAuthorizationManager = AuthenticatedAuthorizationManager.authenticated();
        Intrinsics.checkNotNullExpressionValue(authenticatedAuthorizationManager, (String)"authenticated()");
        this.authenticated = authenticatedAuthorizationManager;
    }

    @Nullable
    public final Boolean getShouldFilterAllDispatcherTypes() {
        return this.shouldFilterAllDispatcherTypes;
    }

    public final void setShouldFilterAllDispatcherTypes(@Nullable Boolean bl) {
        this.shouldFilterAllDispatcherTypes = bl;
    }

    public final void authorize(@NotNull RequestMatcher matches, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)matches, (String)"matches");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule(matches, access));
    }

    public static /* synthetic */ void authorize$default(AuthorizeHttpRequestsDsl authorizeHttpRequestsDsl, RequestMatcher requestMatcher, AuthorizationManager authorizationManager, int n, Object object) {
        if ((n & 1) != 0) {
            RequestMatcher requestMatcher2 = AnyRequestMatcher.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)requestMatcher2, (String)"INSTANCE");
            requestMatcher = requestMatcher2;
        }
        authorizeHttpRequestsDsl.authorize(requestMatcher, (AuthorizationManager<RequestAuthorizationContext>)authorizationManager);
    }

    public final void authorize(@NotNull String pattern, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, null, null, access, 12, null));
    }

    public final void authorize(@NotNull HttpMethod method, @NotNull String pattern, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, null, method, access, 4, null));
    }

    public final void authorize(@NotNull String pattern, @NotNull String servletPath, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)servletPath, (String)"servletPath");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, servletPath, null, access, 8, null));
    }

    public final void authorize(@NotNull HttpMethod method, @NotNull String pattern, @NotNull String servletPath, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)servletPath, (String)"servletPath");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, servletPath, method, access));
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasAuthority(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        AuthorityAuthorizationManager authorityAuthorizationManager = AuthorityAuthorizationManager.hasAuthority(authority);
        Intrinsics.checkNotNullExpressionValue(authorityAuthorizationManager, (String)"hasAuthority(authority)");
        return authorityAuthorizationManager;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasAnyAuthority(String ... authorities) {
        Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
        AuthorityAuthorizationManager authorityAuthorizationManager = AuthorityAuthorizationManager.hasAnyAuthority(Arrays.copyOf(authorities, authorities.length));
        Intrinsics.checkNotNullExpressionValue(authorityAuthorizationManager, (String)"hasAnyAuthority(*authorities)");
        return authorityAuthorizationManager;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        AuthorityAuthorizationManager authorityAuthorizationManager = AuthorityAuthorizationManager.hasRole(role);
        Intrinsics.checkNotNullExpressionValue(authorityAuthorizationManager, (String)"hasRole(role)");
        return authorityAuthorizationManager;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasAnyRole(String ... roles) {
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        AuthorityAuthorizationManager authorityAuthorizationManager = AuthorityAuthorizationManager.hasAnyRole(Arrays.copyOf(roles, roles.length));
        Intrinsics.checkNotNullExpressionValue(authorityAuthorizationManager, (String)"hasAnyRole(*roles)");
        return authorityAuthorizationManager;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> getPermitAll() {
        return this.permitAll;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> getDenyAll() {
        return this.denyAll;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> getAuthenticated() {
        return this.authenticated;
    }

    @NotNull
    public final Function1<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry, Unit> get$spring_security_config() {
        return (Function1)new Function1<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry, Unit>(this){
            final /* synthetic */ AuthorizeHttpRequestsDsl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests) {
                block6: {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
                    Iterable iterable = AuthorizeHttpRequestsDsl.access$getAuthorizationRules$p(this.this$0);
                    Object object = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AbstractRequestMatcherDsl.AuthorizationManagerRule rule = (AbstractRequestMatcherDsl.AuthorizationManagerRule)element$iv;
                        boolean bl = false;
                        AbstractRequestMatcherDsl.AuthorizationManagerRule authorizationManagerRule = rule;
                        if (authorizationManagerRule instanceof AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule) {
                            RequestMatcher[] requestMatcherArray = new RequestMatcher[]{((AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule)rule).getMatcher()};
                            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(requestMatcherArray)).access(rule.getRule());
                            continue;
                        }
                        if (!(authorizationManagerRule instanceof AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)) continue;
                        switch (get.WhenMappings.$EnumSwitchMapping$0[((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getPatternType().ordinal()]) {
                            case 1: {
                                String[] stringArray = new String[]{((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getPattern()};
                                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getHttpMethod(), stringArray)).access(rule.getRule());
                                break;
                            }
                            case 2: {
                                HandlerMappingIntrospector introspector;
                                Intrinsics.checkNotNullExpressionValue((Object)requests.getApplicationContext().getBean(AuthorizeHttpRequestsDsl.access$getHANDLER_MAPPING_INTROSPECTOR_BEAN_NAME$p((AuthorizeHttpRequestsDsl)object), HandlerMappingIntrospector.class), (String)"requests.applicationCont\u2026Introspector::class.java)");
                                MvcRequestMatcher mvcMatcher = new MvcRequestMatcher.Builder(introspector).servletPath(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getServletPath()).pattern(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getPattern());
                                mvcMatcher.setMethod(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getHttpMethod());
                                RequestMatcher[] requestMatcherArray = new RequestMatcher[]{mvcMatcher};
                                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(requestMatcherArray)).access(rule.getRule());
                            }
                        }
                    }
                    Boolean bl = this.this$0.getShouldFilterAllDispatcherTypes();
                    if (bl == null) break block6;
                    object = bl;
                    boolean shouldFilter = (Boolean)object;
                    boolean bl2 = false;
                    requests.shouldFilterAllDispatcherTypes(shouldFilter);
                }
            }
        };
    }

    private static final AuthorizationDecision permitAll$lambda$0(Supplier supplier, RequestAuthorizationContext requestAuthorizationContext) {
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)requestAuthorizationContext, (String)"<anonymous parameter 1>");
        return new AuthorizationDecision(true);
    }

    private static final AuthorizationDecision denyAll$lambda$1(Supplier supplier, RequestAuthorizationContext requestAuthorizationContext) {
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)requestAuthorizationContext, (String)"<anonymous parameter 1>");
        return new AuthorizationDecision(false);
    }

    public static final /* synthetic */ List access$getAuthorizationRules$p(AuthorizeHttpRequestsDsl $this) {
        return $this.authorizationRules;
    }

    public static final /* synthetic */ String access$getHANDLER_MAPPING_INTROSPECTOR_BEAN_NAME$p(AuthorizeHttpRequestsDsl $this) {
        return $this.HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME;
    }
}

