/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.ExpressionBasedPostInvocationAdvice;
import org.springframework.security.access.expression.method.ExpressionBasedPreInvocationAdvice;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityMetadataSourceAdvisor;
import org.springframework.security.access.method.AbstractMethodSecurityMetadataSource;
import org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PrePostAdviceReactiveMethodInterceptor;
import org.springframework.security.access.prepost.PrePostAnnotationSecurityMetadataSource;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.core.GrantedAuthorityDefaults;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
class ReactiveMethodSecurityConfiguration
implements ImportAware {
    private int advisorOrder;
    private GrantedAuthorityDefaults grantedAuthorityDefaults;

    ReactiveMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static MethodSecurityMetadataSourceAdvisor methodSecurityInterceptor(AbstractMethodSecurityMetadataSource source, ReactiveMethodSecurityConfiguration configuration) {
        MethodSecurityMetadataSourceAdvisor advisor = new MethodSecurityMetadataSourceAdvisor("securityMethodInterceptor", source, "methodMetadataSource");
        advisor.setOrder(configuration.advisorOrder);
        return advisor;
    }

    @Bean
    @Role(value=2)
    static DelegatingMethodSecurityMetadataSource methodMetadataSource(MethodSecurityExpressionHandler methodSecurityExpressionHandler) {
        ExpressionBasedAnnotationAttributeFactory attributeFactory = new ExpressionBasedAnnotationAttributeFactory(methodSecurityExpressionHandler);
        PrePostAnnotationSecurityMetadataSource prePostSource = new PrePostAnnotationSecurityMetadataSource(attributeFactory);
        return new DelegatingMethodSecurityMetadataSource(Arrays.asList(prePostSource));
    }

    @Bean
    static PrePostAdviceReactiveMethodInterceptor securityMethodInterceptor(AbstractMethodSecurityMetadataSource source, MethodSecurityExpressionHandler handler) {
        ExpressionBasedPostInvocationAdvice postAdvice = new ExpressionBasedPostInvocationAdvice(handler);
        ExpressionBasedPreInvocationAdvice preAdvice = new ExpressionBasedPreInvocationAdvice();
        preAdvice.setExpressionHandler(handler);
        return new PrePostAdviceReactiveMethodInterceptor(source, preAdvice, postAdvice);
    }

    @Bean
    @Role(value=2)
    static DefaultMethodSecurityExpressionHandler methodSecurityExpressionHandler(ReactiveMethodSecurityConfiguration configuration) {
        DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();
        if (configuration.grantedAuthorityDefaults != null) {
            handler.setDefaultRolePrefix(configuration.grantedAuthorityDefaults.getRolePrefix());
        }
        return handler;
    }

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.advisorOrder = (Integer)importMetadata.getAnnotationAttributes(EnableReactiveMethodSecurity.class.getName()).get("order");
    }

    @Autowired(required=false)
    void setGrantedAuthorityDefaults(GrantedAuthorityDefaults grantedAuthorityDefaults) {
        this.grantedAuthorityDefaults = grantedAuthorityDefaults;
    }
}

