/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.security.authentication.AuthenticationObservationContext;
import org.springframework.security.authentication.AuthenticationObservationConvention;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ObservationReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private final ObservationRegistry registry;
    private final ReactiveAuthenticationManager delegate;
    private ObservationConvention<AuthenticationObservationContext> convention = new AuthenticationObservationConvention();

    public ObservationReactiveAuthenticationManager(ObservationRegistry registry, ReactiveAuthenticationManager delegate) {
        this.registry = registry;
        this.delegate = delegate;
    }

    @Override
    public Mono<Authentication> authenticate(Authentication authentication) throws AuthenticationException {
        AuthenticationObservationContext context = new AuthenticationObservationContext();
        context.setAuthenticationRequest(authentication);
        context.setAuthenticationManagerClass(this.delegate.getClass());
        return Mono.deferContextual(contextView -> {
            Observation observation = Observation.createNotStarted(this.convention, () -> context, this.registry).parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            return this.delegate.authenticate(authentication).doOnSuccess(result -> {
                context.setAuthenticationResult((Authentication)result);
                observation.stop();
            }).doOnCancel(observation::stop).doOnError(t -> {
                observation.error((Throwable)t);
                observation.stop();
            });
        });
    }

    public void setObservationConvention(ObservationConvention<AuthenticationObservationContext> convention) {
        Assert.notNull(convention, "The observation convention cannot be null");
        this.convention = convention;
    }
}

