/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.afterinvocation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.acls.afterinvocation.Filterer;

class CollectionFilterer<T>
implements Filterer<T> {
    protected static final Log logger = LogFactory.getLog(CollectionFilterer.class);
    private final Collection<T> collection;
    private final Set<T> removeList;

    CollectionFilterer(Collection<T> collection) {
        this.collection = collection;
        this.removeList = new HashSet<T>();
    }

    @Override
    public Object getFilteredObject() {
        Iterator<T> removeIter = this.removeList.iterator();
        int originalSize = this.collection.size();
        while (removeIter.hasNext()) {
            this.collection.remove(removeIter.next());
        }
        logger.debug(LogMessage.of(() -> "Original collection contained " + originalSize + " elements; now contains " + this.collection.size() + " elements"));
        return this.collection;
    }

    @Override
    public Iterator<T> iterator() {
        return this.collection.iterator();
    }

    @Override
    public void remove(T object) {
        this.removeList.add(object);
    }
}

