/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils.apm;

import co.elastic.apm.attach.ElasticApmAttacher;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="elastic")
@ConditionalOnProperty(value={"elastic.apm.enabled"}, havingValue="true")
public class ElasticAPMConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticAPMConfiguration.class);
    private Map<String, String> apmProperties;

    public Map<String, String> getApm() {
        return SerializationUtils.clone(new HashMap<String, String>(this.apmProperties));
    }

    public void setApm(Map<String, String> apmProperties) {
        this.apmProperties = SerializationUtils.clone(new HashMap<String, String>(apmProperties));
    }

    @PostConstruct
    public void attachApmAgent() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}", (Object)StringUtils.join(this.apmProperties));
        }
        ElasticApmAttacher.attach(this.apmProperties);
    }
}

