/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TempFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempFileUtils.class);
    private static final EnumSet<PosixFilePermission> OWNER_PERMISSIONS_ONLY_SET = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
    private static final FileAttribute<Set<PosixFilePermission>> OWNER_PERMISSIONS_ONLY_FILE_ATTRIBUTE = PosixFilePermissions.asFileAttribute(OWNER_PERMISSIONS_ONLY_SET);
    public static final String PNG_FILE_EXTENSION = ".png";
    public static final String JPEG_FILE_EXTENSION = ".jpeg";

    private TempFileUtils() {
    }

    public static Path createSecureTempFile(String prefix, String suffix) throws IOException {
        Path secureTempFile = Files.createTempFile(prefix, suffix, OWNER_PERMISSIONS_ONLY_FILE_ATTRIBUTE);
        TempFileUtils.setPosixIndependentOwnerOnlyFilePermissions(secureTempFile);
        return secureTempFile;
    }

    public static Path createSecureTempFileDeleteOnExit(String prefix, String suffix) throws IOException {
        Path secureTempFile = TempFileUtils.createSecureTempFile(prefix, suffix);
        secureTempFile.toFile().deleteOnExit();
        return secureTempFile;
    }

    public static Path createSecureTempDirectoryAndFile(String directoryPrefix, String prefix, String suffix) throws IOException {
        Path tempSecureParentDir = TempFileUtils.createSecureTempDirectory(directoryPrefix);
        Path secureTempFile = Files.createTempFile(tempSecureParentDir, prefix, suffix, OWNER_PERMISSIONS_ONLY_FILE_ATTRIBUTE);
        TempFileUtils.setPosixIndependentOwnerOnlyFilePermissions(secureTempFile);
        return secureTempFile;
    }

    public static Path createSecureTempDirectory(String prefix) throws IOException {
        Path secureTempFile = Files.createTempDirectory(prefix, OWNER_PERMISSIONS_ONLY_FILE_ATTRIBUTE);
        TempFileUtils.setPosixIndependentOwnerOnlyFilePermissions(secureTempFile);
        return secureTempFile;
    }

    private static void setPosixIndependentOwnerOnlyFilePermissions(Path path) {
        File file = path.toFile();
        if (!(file.setReadable(true, true) && file.setWritable(true, true) && file.setExecutable(true, true))) {
            LOGGER.debug("Setting permissions failed on file {}", (Object)file.getAbsolutePath());
        }
    }
}

