/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;

public class RdfNamespaceContext
implements NamespaceContext {
    public static final String RDF_NAMESPACE_PREFIX = "rdf";
    public static final String EDM_NAMESPACE_PREFIX = "edm";
    public static final String ORE_NAMESPACE_PREFIX = "ore";
    private static final Map<String, String> PREFIX_TO_NAMESPACE_MAP = new HashMap<String, String>();

    @Override
    public String getNamespaceURI(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return Optional.ofNullable(PREFIX_TO_NAMESPACE_MAP.get(s)).orElse("");
    }

    @Override
    public String getPrefix(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return PREFIX_TO_NAMESPACE_MAP.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(s)).map(Map.Entry::getKey).findAny().orElse(null);
    }

    @Override
    public Iterator<String> getPrefixes(String s) {
        return Optional.ofNullable(this.getPrefix(s)).map(Collections::singletonList).orElseGet(Collections::emptyList).iterator();
    }

    static {
        PREFIX_TO_NAMESPACE_MAP.put("", "");
        PREFIX_TO_NAMESPACE_MAP.put("xml", "http://www.w3.org/XML/1998/namespace");
        PREFIX_TO_NAMESPACE_MAP.put("xmlns", "http://www.w3.org/2000/xmlns/");
        PREFIX_TO_NAMESPACE_MAP.put(RDF_NAMESPACE_PREFIX, "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        PREFIX_TO_NAMESPACE_MAP.put(ORE_NAMESPACE_PREFIX, "http://www.openarchives.org/ore/terms/");
        PREFIX_TO_NAMESPACE_MAP.put(EDM_NAMESPACE_PREFIX, "http://www.europeana.eu/schemas/edm/");
    }
}

