/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import eu.europeana.metis.utils.CompressedFileExtension;
import eu.europeana.metis.utils.TempFileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedFileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressedFileHandler.class);
    private static final String MAC_TEMP_FOLDER = "__MACOSX";
    private static final String MAC_TEMP_FILE = ".DS_Store";
    public static final String FILE_NAME_BANNED_CHARACTERS = "% $:?&#<>|*,\u0000";

    public static void extractFile(Path compressedFile, Path destinationFolder) throws IOException {
        CompressedFileExtension compressingExtension = CompressedFileExtension.forPath(compressedFile);
        if (compressingExtension == null) {
            throw new IOException("Can't process archive of this type: " + String.valueOf(compressedFile));
        }
        switch (compressingExtension) {
            case ZIP: {
                CompressedFileHandler.extractZipFile(compressedFile, destinationFolder);
                break;
            }
            case GZIP: {
                CompressedFileHandler.extractGzFile(compressedFile, destinationFolder);
                break;
            }
            case TAR: {
                CompressedFileHandler.extractTarFile(compressedFile, destinationFolder);
                break;
            }
            case TGZIP: 
            case TAR_GZ: {
                CompressedFileHandler.extractTarGzFile(compressedFile, destinationFolder);
                break;
            }
            default: {
                throw new IllegalStateException("Shouldn't be here. Extension found: " + compressingExtension.name());
            }
        }
    }

    public List<ByteArrayInputStream> getContentFromZipFile(InputStream providedZipFile) throws IOException {
        try (ZipFile zipFile = this.createInMemoryZipFileObject(providedZipFile);){
            List<InputStream> streams = this.getContentFromZipFile(zipFile);
            ArrayList<ByteArrayInputStream> result = new ArrayList<ByteArrayInputStream>(streams.size());
            for (InputStream stream : streams) {
                result.add(new ByteArrayInputStream(IOUtils.toByteArray(stream)));
            }
            ArrayList<ByteArrayInputStream> arrayList = result;
            return arrayList;
        }
    }

    private ZipFile createInMemoryZipFileObject(InputStream content) throws IOException {
        File tempFile = TempFileUtils.createSecureTempFile(content.getClass().getSimpleName(), ".zip").toFile();
        FileUtils.copyInputStreamToFile((InputStream)content, (File)tempFile);
        LOGGER.info("Temp file: {} created.", (Object)tempFile);
        return new ZipFile(tempFile, 5);
    }

    public List<String> getRecordsFromZipFile(ZipFile zipFile) throws IOException {
        List<InputStream> streams = this.getContentFromZipFile(zipFile);
        ArrayList<String> result = new ArrayList<String>(streams.size());
        for (InputStream stream : streams) {
            result.add(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8));
        }
        return result;
    }

    private List<InputStream> getContentFromZipFile(ZipFile zipFile) throws IOException {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        Iterator entries = zipFile.stream().iterator();
        while (entries.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)entries.next();
            if (!this.accept(zipEntry)) continue;
            result.add(zipFile.getInputStream(zipEntry));
        }
        return result;
    }

    public boolean accept(ZipEntry zipEntry) {
        return !zipEntry.isDirectory() && !zipEntry.getName().startsWith(MAC_TEMP_FOLDER) && !zipEntry.getName().endsWith(MAC_TEMP_FILE);
    }

    private static void extractZipFile(Path compressedFile, Path destinationFolder) throws IOException {
        ArrayList<Path> nestedCompressedFiles = new ArrayList<Path>();
        try (ZipArchiveInputStream is = new ZipArchiveInputStream(Files.newInputStream(compressedFile, new OpenOption[0]));){
            ZipArchiveEntry entry;
            while ((entry = is.getNextZipEntry()) != null) {
                String entryName = CompressedFileHandler.replaceBannedCharacters(entry.getName());
                Path newPath = CompressedFileHandler.zipSlipVulnerabilityProtect(entryName, destinationFolder);
                if (CompressedFileExtension.hasCompressedFileExtension(entry.getName())) {
                    nestedCompressedFiles.add(destinationFolder.resolve(entry.getName()));
                }
                CompressedFileHandler.extract(is, entry, newPath);
            }
        }
        for (Path nestedCompressedFile : nestedCompressedFiles) {
            CompressedFileHandler.extractFile(nestedCompressedFile, nestedCompressedFile.getParent());
        }
    }

    private static void extractTarGzFile(Path compressedFile, Path destinationFolder) throws IOException {
        HashSet<Path> nestedCompressedFiles = new HashSet<Path>();
        try (InputStream fi = Files.newInputStream(compressedFile, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             GzipCompressorInputStream gzi = new GzipCompressorInputStream(bi);
             TarArchiveInputStream ti = new TarArchiveInputStream(gzi);){
            TarArchiveEntry entry;
            while ((entry = ti.getNextEntry()) != null) {
                String entryName = CompressedFileHandler.replaceBannedCharacters(entry.getName());
                Path newPath = CompressedFileHandler.zipSlipVulnerabilityProtect(entryName, destinationFolder);
                if (CompressedFileExtension.hasCompressedFileExtension(entry.getName())) {
                    nestedCompressedFiles.add(destinationFolder.resolve(entry.getName()));
                }
                CompressedFileHandler.extract(ti, entry, newPath);
            }
        }
        for (Path file : nestedCompressedFiles) {
            CompressedFileHandler.extractFile(file, file.getParent());
        }
    }

    private static void extractGzFile(Path compressedFile, Path destinationFolder) throws IOException {
        Path destination = CompressedFileExtension.removeExtension(destinationFolder.resolve(compressedFile.getFileName()));
        try (GzipCompressorInputStream inputStream = new GzipCompressorInputStream(Files.newInputStream(compressedFile, new OpenOption[0]));
             OutputStream outputStream = Files.newOutputStream(destination, new OpenOption[0]);){
            IOUtils.copy((InputStream)inputStream, outputStream);
        }
    }

    private static void extractTarFile(Path compressedFile, Path destinationFolder) throws IOException {
        ArrayList<Path> nestedCompressedFiles = new ArrayList<Path>();
        try (TarArchiveInputStream is = new TarArchiveInputStream(Files.newInputStream(compressedFile, new OpenOption[0]));){
            TarArchiveEntry entry;
            while ((entry = is.getNextTarEntry()) != null) {
                String entryName = CompressedFileHandler.replaceBannedCharacters(entry.getName());
                Path newPath = CompressedFileHandler.zipSlipVulnerabilityProtect(entryName, destinationFolder);
                if (CompressedFileExtension.hasCompressedFileExtension(entry.getName())) {
                    nestedCompressedFiles.add(destinationFolder.resolve(entry.getName()));
                }
                CompressedFileHandler.extract(is, entry, newPath);
            }
        }
        for (Path nestedCompressedFile : nestedCompressedFiles) {
            CompressedFileHandler.extractFile(nestedCompressedFile, nestedCompressedFile.getParent());
        }
    }

    private static String replaceBannedCharacters(String entryName) {
        return entryName.replaceAll("[% $:?&#<>|*,\u0000]", "_");
    }

    private static void extract(ArchiveInputStream is, ArchiveEntry entry, Path newPath) throws IOException {
        if (entry.isDirectory()) {
            Files.createDirectories(newPath, new FileAttribute[0]);
        } else {
            Path parent = newPath.getParent();
            if (parent != null && Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(is, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static Path zipSlipVulnerabilityProtect(String entryName, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(entryName);
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Entry is outside of the target dir: " + entryName);
        }
        return normalizePath;
    }
}

