/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;

public enum CompressedFileExtension {
    ZIP(".zip"),
    GZIP(".gz"),
    TAR(".tar"),
    TAR_GZ(".tar.gz"),
    TGZIP(".tgz");

    private final String extension;

    private CompressedFileExtension(String extension) {
        this.extension = extension;
    }

    public final String getExtension() {
        return this.extension;
    }

    private boolean hasExtension(String fileName) {
        return fileName.endsWith(this.getExtension());
    }

    public static CompressedFileExtension forPath(Path file) {
        return Arrays.stream(CompressedFileExtension.values()).sorted(Comparator.comparing(candidate -> -candidate.getExtension().length())).filter(extension -> extension.hasExtension(file.toString())).findFirst().orElse(null);
    }

    public static Path removeExtension(Path file) {
        CompressedFileExtension extension = CompressedFileExtension.forPath(file);
        if (extension == null || file.getFileName() == null) {
            throw new IllegalArgumentException("File " + String.valueOf(file) + " is not a recognised compressed file.");
        }
        String fileName = file.getFileName().toString();
        String newFileName = fileName.substring(0, fileName.length() - extension.getExtension().length());
        return Optional.ofNullable(file.getParent()).map(parent -> parent.resolve(newFileName)).orElseGet(() -> Path.of(newFileName, new String[0]));
    }

    public static boolean hasCompressedFileExtension(Path file) {
        return file.getFileName() != null && CompressedFileExtension.hasCompressedFileExtension(file.getFileName().toString());
    }

    public static boolean hasCompressedFileExtension(String fileName) {
        return Stream.of(CompressedFileExtension.values()).anyMatch(extension -> extension.hasExtension(fileName));
    }
}

