/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.urls;

import eu.europeana.cloud.service.commons.urls.UrlBuilder;
import eu.europeana.cloud.service.commons.urls.UrlBuilderException;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UrlParser {
    private static final char DIR_SEPARATOR = '/';
    private static final List<UrlPart> CLOUD_ID_URL_PATTERN = Arrays.asList(UrlPart.CONTEXT, UrlPart.RECORDS);
    private static final List<UrlPart> REPRESENTATIONS_URL_PATTERN = Arrays.asList(UrlPart.CONTEXT, UrlPart.RECORDS, UrlPart.REPRESENTATIONS);
    private static final List<UrlPart> REPRESENTATION_VERSION_URL_PATTERN = Arrays.asList(UrlPart.CONTEXT, UrlPart.RECORDS, UrlPart.REPRESENTATIONS, UrlPart.VERSIONS);
    private static final List<UrlPart> REPRESENTATION_VERSION_FILE_URL_PATTERN = Arrays.asList(UrlPart.CONTEXT, UrlPart.RECORDS, UrlPart.REPRESENTATIONS, UrlPart.VERSIONS, UrlPart.FILES);
    private static final List<UrlPart> DATASET_URL_PATTERN = Arrays.asList(UrlPart.CONTEXT, UrlPart.DATA_PROVIDERS, UrlPart.DATA_SETS);
    private String[] urlParts;
    private Map<UrlPart, String> parts = new LinkedHashMap<UrlPart, String>();
    private URL resourceUrl;
    private String appLocation;

    public UrlParser(String url) throws MalformedURLException {
        String path;
        this.resourceUrl = new URL(url);
        this.appLocation = this.resourceUrl.getProtocol() + "://" + this.resourceUrl.getHost();
        if (this.resourceUrl.getPort() != -1) {
            this.appLocation = this.appLocation + ":" + this.resourceUrl.getPort();
        }
        if ((path = this.resourceUrl.getPath()).startsWith("/")) {
            path = path.substring(1);
        }
        this.urlParts = path.split("/");
        for (int i = 0; i < this.urlParts.length; ++i) {
            if (this.urlParts[i].equalsIgnoreCase(UrlPart.RECORDS.getValue())) {
                i = this.handleUrlPart(i, UrlPart.RECORDS);
                continue;
            }
            if (this.urlParts[i].equalsIgnoreCase(UrlPart.REPRESENTATIONS.getValue())) {
                i = this.handleUrlPart(i, UrlPart.REPRESENTATIONS);
                continue;
            }
            if (this.urlParts[i].equalsIgnoreCase(UrlPart.VERSIONS.getValue())) {
                i = this.handleUrlPart(i, UrlPart.VERSIONS);
                continue;
            }
            if (this.urlParts[i].equalsIgnoreCase(UrlPart.FILES.getValue())) {
                i = this.handleFileUrlPart(i);
                continue;
            }
            if (this.urlParts[i].equalsIgnoreCase(UrlPart.DATA_SETS.getValue())) {
                i = this.handleUrlPart(i, UrlPart.DATA_SETS);
                continue;
            }
            if (this.urlParts[i].equalsIgnoreCase(UrlPart.DATA_PROVIDERS.getValue())) {
                i = this.handleUrlPart(i, UrlPart.DATA_PROVIDERS);
                continue;
            }
            if (i != 0) continue;
            this.parts.put(UrlPart.CONTEXT, this.urlParts[i]);
        }
    }

    private int handleFileUrlPart(int i) {
        if (this.urlParts.length > i + 1) {
            StringBuilder filePath = new StringBuilder();
            do {
                filePath.append("/" + this.urlParts[i + 1]);
            } while (++i < this.urlParts.length - 1);
            this.parts.put(UrlPart.FILES, filePath.toString());
        } else {
            this.parts.put(UrlPart.FILES, null);
        }
        return i;
    }

    private int handleUrlPart(int i, UrlPart records) {
        if (this.urlParts.length > i + 1) {
            this.parts.put(records, this.urlParts[i + 1]);
            ++i;
        } else {
            this.parts.put(records, null);
        }
        return i;
    }

    public boolean isUrlToDatasetsList() {
        return this.matches(this.parts, DATASET_URL_PATTERN) && this.containEmptyValue(UrlPart.DATA_SETS);
    }

    public boolean isUrlToDataset() {
        return this.matches(this.parts, DATASET_URL_PATTERN) && this.containNonEmptyValue(UrlPart.DATA_SETS);
    }

    public boolean isUrlToCloudId() {
        return this.matches(this.parts, CLOUD_ID_URL_PATTERN) && this.containNonEmptyValue(UrlPart.RECORDS);
    }

    public boolean isUrlToRepresentations() {
        return this.matches(this.parts, REPRESENTATIONS_URL_PATTERN) && this.containEmptyValue(UrlPart.REPRESENTATIONS);
    }

    public boolean isUrlToRepresentation() {
        return this.matches(this.parts, REPRESENTATIONS_URL_PATTERN) && this.containNonEmptyValue(UrlPart.REPRESENTATIONS);
    }

    public boolean isUrlToRepresentationVersions() {
        return this.matches(this.parts, REPRESENTATION_VERSION_URL_PATTERN) && this.containEmptyValue(UrlPart.VERSIONS);
    }

    public boolean isUrlToRepresentationVersion() {
        return this.matches(this.parts, REPRESENTATION_VERSION_URL_PATTERN) && this.containNonEmptyValue(UrlPart.VERSIONS);
    }

    public boolean isUrlToRepresentationVersionFiles() {
        return this.containEmptyValue(UrlPart.FILES);
    }

    public boolean isUrlToRepresentationVersionFile() {
        return this.matches(this.parts, REPRESENTATION_VERSION_FILE_URL_PATTERN) && this.containNonEmptyValue(UrlPart.FILES);
    }

    private boolean containEmptyValue(UrlPart urlPart) {
        return this.parts.containsKey((Object)urlPart) && (this.parts.get((Object)urlPart) == null || this.parts.get((Object)urlPart).isEmpty());
    }

    private boolean containNonEmptyValue(UrlPart urlPart) {
        return this.parts.containsKey((Object)urlPart) && this.parts.get((Object)urlPart) != null && !this.parts.get((Object)urlPart).isEmpty();
    }

    private boolean matches(Map<UrlPart, String> parts, List<UrlPart> pattern) {
        if (parts.keySet().size() != pattern.size()) {
            return false;
        }
        int counter = 0;
        for (Map.Entry<UrlPart, String> entry : parts.entrySet()) {
            UrlPart urlPart = entry.getKey();
            UrlPart part = pattern.get(counter);
            if (part != null && urlPart.equals((Object)part)) {
                ++counter;
                continue;
            }
            return false;
        }
        return true;
    }

    public String getPart(UrlPart urlPart) {
        return this.parts.get((Object)urlPart);
    }

    public String getVersionUrl() throws UrlBuilderException {
        UrlBuilder ecloudUrlBuilder = new UrlBuilder(this.parts);
        String result = ecloudUrlBuilder.clear().withCloudID().withRepresentation().withVersion().build();
        return this.appLocation + result;
    }

    public String getVersionsUrl() throws UrlBuilderException {
        UrlBuilder ecloudUrlBuilder = new UrlBuilder(this.parts);
        String result = ecloudUrlBuilder.clear().withCloudID().withRepresentation().withVersionWithoutValue().build();
        return this.appLocation + result;
    }

    public String getDataSetsUrl() throws UrlBuilderException {
        UrlBuilder ecloudUrlBuilder = new UrlBuilder(this.parts);
        String result = ecloudUrlBuilder.clear().withDataProvider().withDataSetWithoutValue().build();
        return this.appLocation + result;
    }
}

