/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.service.commons.utils.DateHelper;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class RecordServiceClient
extends MCSClient {
    public RecordServiceClient(String baseUrl) {
        this(baseUrl, 20000, 60000);
    }

    public RecordServiceClient(String baseUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this(baseUrl, null, null, connectTimeoutInMillis, readTimeoutInMillis);
    }

    public RecordServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, username, password, 20000, 60000);
    }

    public RecordServiceClient(String baseUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        if (username != null || password != null) {
            this.client.register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        }
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public static void main(String[] args) {
        RecordServiceClient c = new RecordServiceClient("http://127.0.0.1:8080/mcs");
        try {
            c.getRecord("sample");
        }
        catch (MCSException e) {
            throw new RuntimeException(e);
        }
    }

    public Record getRecord(String cloudId) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<Record>(Record.class), () -> this.client.target(this.baseUrl).path("/records/{cloudId}").resolveTemplate("cloudId", cloudId).request().get());
    }

    public void deleteRecord(String cloudId) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}").resolveTemplate("cloudId", cloudId).request().delete());
    }

    public List<Representation> getRepresentations(String cloudId) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<List<Representation>>(new GenericType<List<Representation>>(this){}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations").resolveTemplate("cloudId", cloudId).request().get());
    }

    public Representation getRepresentation(String cloudId, String representationName) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<Representation>(Representation.class, new Response.Status[]{Response.Status.OK, Response.Status.TEMPORARY_REDIRECT}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().get());
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, UUID version, String datasetId) throws MCSException {
        Form form = new Form();
        form.param("providerId", providerId);
        form.param("dataSetId", datasetId);
        if (version != null) {
            form.param("version", version.toString());
        }
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, String datasetId) throws MCSException {
        return this.createRepresentation(cloudId, representationName, providerId, null, datasetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI createRepresentation(String cloudId, String representationName, String providerId, String datasetId, InputStream data, String fileName, String mediaType) throws IOException, MCSException {
        FormDataMultiPart multiPart = this.prepareRequestBody(providerId, datasetId, data, fileName, mediaType);
        try {
            URI uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().header("Content-Type", "multipart/form-data").post(Entity.entity(multiPart, "multipart/form-data")));
            return uRI;
        }
        finally {
            this.closeDataSources(data, multiPart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI createRepresentation(String cloudId, String representationName, String providerId, UUID version, String datasetId, InputStream data, String fileName, String mediaType) throws IOException, MCSException {
        FormDataMultiPart multiPart = this.prepareRequestBody(providerId, datasetId, data, fileName, mediaType);
        if (version != null) {
            multiPart.field("version", version.toString());
        }
        try {
            URI uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().post(Entity.entity(multiPart, "multipart/form-data")));
            return uRI;
        }
        finally {
            this.closeDataSources(data, multiPart);
        }
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, String datasetId, InputStream data, String mediaType) throws IOException, MCSException {
        return this.createRepresentation(cloudId, representationName, providerId, datasetId, data, null, mediaType);
    }

    public void deleteRepresentation(String cloudId, String representationName) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().delete());
    }

    public List<Representation> getRepresentations(String cloudId, String representationName) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<List<Representation>>(new GenericType<List<Representation>>(this){}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).request().get());
    }

    public Representation getRepresentation(String cloudId, String representationName, String version) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<Representation>(Representation.class), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().get());
    }

    public Representation getRepresentation(String cloudId, String representationName, String version, String key, String value) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<Representation>(Representation.class), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().header(key, value).get());
    }

    public void deleteRepresentation(String cloudId, String representationName, String version) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version:.+}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().delete());
    }

    public URI persistRepresentation(String cloudId, String representationName, String version) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/persist").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().post(Entity.entity(new Form(), MediaType.APPLICATION_FORM_URLENCODED_TYPE)));
    }

    @Deprecated(since="6-SNAPSHOT")
    public List<Representation> getRepresentationsByRevision(String cloudId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp) throws MCSException {
        return this.getRepresentationsByRevision(cloudId, representationName, new Revision(revisionName, revisionProviderId, DateHelper.parseISODate(revisionTimestamp)));
    }

    public List<Representation> getRepresentationsByRevision(String cloudId, String representationName, Revision revision) throws MCSException {
        if (revision.getRevisionProviderId() == null) {
            throw new MCSException("RevisionProviderId is required");
        }
        return this.manageResponse(new MCSClient.ResponseParams<List<Representation>>(new GenericType<List<Representation>>(this){}), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/revisions/{revisionName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("revisionName", revision.getRevisionName()).queryParam("revisionProviderId", revision.getRevisionProviderId()).queryParam("revisionTimestamp", DateHelper.getISODateString(revision.getCreationTimeStamp())).request().get());
    }

    private FormDataMultiPart prepareRequestBody(String providerId, String datasetId, InputStream data, String fileName, String mediaType) {
        FormDataMultiPart requestBody = new FormDataMultiPart();
        requestBody.field("providerId", providerId).field("dataSetId", datasetId).field("mimeType", mediaType).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
        if (fileName == null || fileName.trim().isEmpty()) {
            fileName = UUID.randomUUID().toString();
        }
        requestBody.field("fileName", fileName);
        return requestBody;
    }

    private void closeDataSources(InputStream data, MultiPart multiPartData) throws IOException {
        IOUtils.closeQuietly(data);
        if (multiPartData != null) {
            multiPartData.close();
        }
    }
}

