/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class FileServiceClient
extends MCSClient {
    private static final String IO_EXCEPTION_MESSAGE = "Some I/O problem occurs";

    public FileServiceClient(String baseUrl) {
        this(baseUrl, null, null, 20000, 60000);
    }

    public FileServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, username, password, 20000, 60000);
    }

    public FileServiceClient(String baseUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        if (username != null || password != null) {
            this.client.register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        }
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<InputStream>(InputStream.class), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName).request().get());
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName, String range) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<InputStream>(InputStream.class, Response.Status.PARTIAL_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName).request().header("Range", range).get());
    }

    public InputStream getFile(String fileUrl) throws MCSException {
        return this.manageResponse(new MCSClient.ResponseParams<InputStream>(InputStream.class), () -> this.client.target(fileUrl).request().get());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public URI uploadFile(String cloudId, String representationName, String version, InputStream data, String mediaType, String expectedMd5) throws MCSException {
        try (InputStream inputStream = data;){
            URI uRI;
            try (FormDataMultiPart multiPart = new FormDataMultiPart();){
                multiPart.field("mimeType", mediaType).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
                uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED, expectedMd5), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().post(Entity.entity(multiPart, multiPart.getMediaType())));
            }
            return uRI;
        }
        catch (IOException ioException) {
            throw MCSExceptionProvider.createException(IO_EXCEPTION_MESSAGE, ioException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public URI uploadFile(String cloudId, String representationName, String version, InputStream data, String mediaType) throws MCSException {
        try (InputStream inputStream = data;){
            URI uRI;
            try (FormDataMultiPart multiPart = new FormDataMultiPart();){
                multiPart.field("mimeType", mediaType).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
                uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().post(Entity.entity(multiPart, multiPart.getMediaType())));
            }
            return uRI;
        }
        catch (IOException ioException) {
            throw MCSExceptionProvider.createException(IO_EXCEPTION_MESSAGE, ioException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public URI uploadFile(String cloudId, String representationName, String version, String fileName, InputStream data, String mediaType) throws MCSException {
        try (InputStream inputStream = data;){
            URI uRI;
            try (FormDataMultiPart multiPart = new FormDataMultiPart();){
                multiPart.field("mimeType", mediaType).field("fileName", fileName).bodyPart(new StreamDataBodyPart("data", data, "application/octet-stream"));
                uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).request().post(Entity.entity(multiPart, multiPart.getMediaType())));
            }
            return uRI;
        }
        catch (IOException ioException) {
            throw MCSExceptionProvider.createException(IO_EXCEPTION_MESSAGE, ioException);
        }
    }

    public URI modifyFile(String cloudId, String representationName, String version, InputStream data, String mediaType, String fileName, String expectedMd5) throws MCSException {
        URI uRI;
        block8: {
            InputStream inputStream = data;
            try {
                uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.NO_CONTENT, expectedMd5), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName).request().put(Entity.entity(data, mediaType)));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    throw MCSExceptionProvider.createException(IO_EXCEPTION_MESSAGE, ioException);
                }
            }
            inputStream.close();
        }
        return uRI;
    }

    public URI modifyFile(String fileUrl, InputStream data, String mediaType) throws MCSException {
        URI uRI;
        block8: {
            InputStream inputStream = data;
            try {
                uRI = this.manageResponse(new MCSClient.ResponseParams<URI>(URI.class, Response.Status.NO_CONTENT), () -> this.client.target(fileUrl).request().put(Entity.entity(data, mediaType)));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    throw MCSExceptionProvider.createException(IO_EXCEPTION_MESSAGE, ioException);
                }
            }
            inputStream.close();
        }
        return uRI;
    }

    public void deleteFile(String cloudId, String representationName, String version, String fileName) throws MCSException {
        this.manageResponse(new MCSClient.ResponseParams<Void>(Void.class, Response.Status.NO_CONTENT), () -> this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName).request().delete());
    }

    public URI getFileUri(String cloudId, String representationName, String version, String fileName) {
        WebTarget target = this.client.target(this.baseUrl).path("/records/{cloudId}/representations/{representationName}/versions/{version}/files/{fileName}").resolveTemplate("cloudId", cloudId).resolveTemplate("representationName", representationName).resolveTemplate("version", version).resolveTemplate("fileName", fileName);
        return target.getUri();
    }
}

