/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.response;

import eu.europeana.cloud.common.model.File;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@XmlRootElement
public class RepresentationRevisionResponse {
    private String cloudId;
    private String representationName;
    private String version;
    private List<File> files = new ArrayList<File>(0);
    private String revisionProviderId;
    private String revisionName;
    private Date revisionTimestamp;

    public RepresentationRevisionResponse() {
    }

    public RepresentationRevisionResponse(String cloudId, String representationName, String version, String revisionProviderId, String revisionName, Date revisionTimestamp) {
        this.cloudId = cloudId;
        this.representationName = representationName;
        this.version = version;
        this.revisionProviderId = revisionProviderId;
        this.revisionName = revisionName;
        this.revisionTimestamp = revisionTimestamp;
    }

    public RepresentationRevisionResponse(String cloudId, String representationName, String version, List<File> files, String revisionProviderId, String revisionName, Date revisionTimestamp) {
        this.cloudId = cloudId;
        this.representationName = representationName;
        this.version = version;
        this.files = files;
        this.revisionProviderId = revisionProviderId;
        this.revisionName = revisionName;
        this.revisionTimestamp = revisionTimestamp;
    }

    public RepresentationRevisionResponse(RepresentationRevisionResponse response) {
        this(response.getCloudId(), response.getRepresentationName(), response.getVersion(), RepresentationRevisionResponse.cloneFiles(response), response.getRevisionProviderId(), response.getRevisionName(), response.getRevisionTimestamp());
    }

    private static List<File> cloneFiles(RepresentationRevisionResponse representation) {
        ArrayList<File> files = new ArrayList<File>(representation.getFiles().size());
        for (File file : representation.getFiles()) {
            files.add(new File(file));
        }
        return files;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public String getRepresentationName() {
        return this.representationName;
    }

    public void setRepresentationName(String representationName) {
        this.representationName = representationName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public String getRevisionProviderId() {
        return this.revisionProviderId;
    }

    public void setRevisionProviderId(String revisionProviderId) {
        this.revisionProviderId = revisionProviderId;
    }

    public String getRevisionName() {
        return this.revisionName;
    }

    public void setRevisionName(String revisionName) {
        this.revisionName = revisionName;
    }

    public Date getRevisionTimestamp() {
        return this.revisionTimestamp;
    }

    public void setRevisionTimestamp(Date revisionTimestamp) {
        this.revisionTimestamp = revisionTimestamp;
    }

    public String getId() {
        return this.getACLId();
    }

    private String getACLId() {
        return this.getCloudId() + "/" + this.getRepresentationName() + "/" + this.getVersion();
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.cloudId);
        hash = 37 * hash + Objects.hashCode(this.representationName);
        hash = 37 * hash + Objects.hashCode(this.version);
        hash = 37 * hash + Objects.hashCode(this.files);
        hash = 37 * hash + Objects.hashCode(this.revisionProviderId);
        hash = 37 * hash + Objects.hashCode(this.revisionName);
        hash = 37 * hash + Objects.hashCode(this.revisionTimestamp);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepresentationRevisionResponse other = (RepresentationRevisionResponse)obj;
        if (!Objects.equals(this.cloudId, other.cloudId)) {
            return false;
        }
        if (!Objects.equals(this.representationName, other.representationName)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.files, other.files)) {
            return false;
        }
        if (!Objects.equals(this.revisionProviderId, other.revisionProviderId)) {
            return false;
        }
        if (!Objects.equals(this.revisionName, other.revisionName)) {
            return false;
        }
        return Objects.equals(this.revisionTimestamp, other.revisionTimestamp);
    }

    public String toString() {
        return "RepresentationRevisionResponse{cloudId=" + this.cloudId + ", representationName=" + this.representationName + ", version=" + this.version + ", files=" + String.valueOf(this.files) + ", revisionProviderId=" + this.revisionProviderId + ", revisionName=" + this.revisionName + ", revisionTimestamp=" + String.valueOf(this.revisionTimestamp) + "}";
    }
}

