/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Frame;
import com.datastax.driver.core.Segment;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentToFrameDecoder
extends MessageToMessageDecoder<Segment> {
    private static final Logger logger = LoggerFactory.getLogger(SegmentToFrameDecoder.class);
    private Frame.Header pendingHeader;
    private final List<ByteBuf> accumulatedSlices = new ArrayList<ByteBuf>();
    private int accumulatedLength;

    SegmentToFrameDecoder() {
        super(Segment.class);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, Segment segment, List<Object> out) {
        if (segment.isSelfContained()) {
            this.decodeSelfContained(segment, out);
        } else {
            this.decodeSlice(segment, ctx.alloc(), out);
        }
    }

    private void decodeSelfContained(Segment segment, List<Object> out) {
        ByteBuf payload = segment.getPayload();
        int frameCount = 0;
        do {
            Frame.Header header = Frame.Header.decode(payload);
            ByteBuf body = payload.readSlice(header.bodyLength);
            body.retain();
            out.add(new Frame(header, body));
            ++frameCount;
        } while (payload.isReadable());
        payload.release();
        logger.trace("Decoded self-contained segment into {} frame(s)", (Object)frameCount);
    }

    private void decodeSlice(Segment segment, ByteBufAllocator allocator, List<Object> out) {
        assert (this.pendingHeader != null ^ (this.accumulatedSlices.isEmpty() && this.accumulatedLength == 0));
        ByteBuf payload = segment.getPayload();
        if (this.pendingHeader == null) {
            this.pendingHeader = Frame.Header.decode(payload);
        }
        this.accumulatedSlices.add(payload);
        this.accumulatedLength += payload.readableBytes();
        logger.trace("StreamId {}: decoded slice {}, {}/{} bytes", this.pendingHeader.streamId, this.accumulatedSlices.size(), this.accumulatedLength, this.pendingHeader.bodyLength);
        assert (this.accumulatedLength <= this.pendingHeader.bodyLength);
        if (this.accumulatedLength == this.pendingHeader.bodyLength) {
            CompositeByteBuf body = allocator.compositeBuffer(this.accumulatedSlices.size());
            body.addComponents(true, this.accumulatedSlices);
            out.add(new Frame(this.pendingHeader, body));
            this.pendingHeader = null;
            this.accumulatedSlices.clear();
            this.accumulatedLength = 0;
        }
    }
}

