/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.utils.Tags;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionServiceClient
extends MCSClient {
    private final Client client;
    private static final Logger logger = LoggerFactory.getLogger(RevisionServiceClient.class);
    private static final String revisionPathWithTag = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/revisions/{REVISION_NAME}/revisionProvider/{REVISION_PROVIDER_ID}/tag/{TAG}";
    private static final String revisionPath = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/revisions";
    private static final String revisionPathWithMultipleTags = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/revisions/{REVISION_NAME}/revisionProvider/{REVISION_PROVIDER_ID}/tags";

    public RevisionServiceClient(String baseUrl) {
        this(baseUrl, 20000, 60000);
    }

    public RevisionServiceClient(String baseUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        this.client = (Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class);
        this.client.property("jersey.config.client.connectTimeout", (Object)connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", (Object)readTimeoutInMillis);
    }

    public RevisionServiceClient(String baseUrl, String username, String password) {
        this(baseUrl, username, password, 20000, 60000);
    }

    public RevisionServiceClient(String baseUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        super(baseUrl);
        this.client = (Client)((Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class)).register((Object)HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
        this.client.property("jersey.config.client.connectTimeout", (Object)connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", (Object)readTimeoutInMillis);
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register((Object)new ECloudBasicAuthFilter(headerValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, String tag) throws DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(revisionPathWithTag).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("REVISION_NAME", (Object)revisionName).resolveTemplate("REVISION_PROVIDER_ID", (Object)revisionProviderId).resolveTemplate("TAG", (Object)tag);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(null);
            URI uRI = this.handleAddRevisionResponse(response);
            return uRI;
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addRevision(String cloudId, String representationName, String version, Revision revision) throws DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(revisionPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.accept(new String[]{"application/json"}).post(Entity.json((Object)revision));
            URI uRI = this.handleAddRevisionResponse(response);
            this.closeResponse(response);
            return uRI;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addRevision(String cloudId, String representationName, String version, Revision revision, String key, String value) throws DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(revisionPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        Invocation.Builder request = target.request().header(key, (Object)value);
        Response response = null;
        try {
            response = request.accept(new String[]{"application/json"}).post(Entity.json((Object)revision));
            URI uRI = this.handleAddRevisionResponse(response);
            this.closeResponse(response);
            return uRI;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    private URI handleAddRevisionResponse(Response response) throws MCSException {
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return response.getLocation();
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, Set<Tags> tags) throws DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(revisionPathWithMultipleTags).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("REVISION_NAME", (Object)revisionName).resolveTemplate("REVISION_PROVIDER_ID", (Object)revisionProviderId);
        Form tagsForm = new Form();
        for (Tags tag : tags) {
            tagsForm.param("tags", tag.getTag());
        }
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(Entity.form((Form)tagsForm));
            URI uRI = this.handleAddRevisionResponse(response);
            return uRI;
        }
        finally {
            this.closeResponse(response);
        }
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    public void close() {
        this.client.close();
    }

    protected void finalize() throws Throwable {
        this.client.close();
    }
}

