/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ObjectUtils;

public abstract class TransactionAspectUtils {
    public static PlatformTransactionManager getTransactionManager(BeanFactory beanFactory, String qualifier) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            return TransactionAspectUtils.getTransactionManager((ConfigurableListableBeanFactory)beanFactory, qualifier);
        }
        if (beanFactory.containsBean(qualifier)) {
            return beanFactory.getBean(qualifier, PlatformTransactionManager.class);
        }
        throw new IllegalStateException("No matching PlatformTransactionManager bean found for bean name '" + qualifier + "'! (Note: Qualifier matching not supported because given BeanFactory does not " + "implement ConfigurableListableBeanFactory.)");
    }

    public static PlatformTransactionManager getTransactionManager(ConfigurableListableBeanFactory bf, String qualifier) {
        Map<String, PlatformTransactionManager> tms = BeanFactoryUtils.beansOfTypeIncludingAncestors(bf, PlatformTransactionManager.class);
        PlatformTransactionManager chosen = null;
        for (String beanName : tms.keySet()) {
            if (!TransactionAspectUtils.isQualifierMatch(qualifier, beanName, bf)) continue;
            if (chosen != null) {
                throw new IllegalStateException("No unique PlatformTransactionManager bean found for qualifier '" + qualifier + "'");
            }
            chosen = tms.get(beanName);
        }
        if (chosen != null) {
            return chosen;
        }
        throw new IllegalStateException("No matching PlatformTransactionManager bean found for qualifier '" + qualifier + "' - neither qualifier match nor bean name match!");
    }

    private static boolean isQualifierMatch(String qualifier, String beanName, ConfigurableListableBeanFactory bf) {
        if (bf.containsBean(beanName)) {
            Qualifier targetAnnotation;
            Method factoryMethod;
            BeanDefinition bd;
            block5: {
                try {
                    AbstractBeanDefinition abd;
                    AutowireCandidateQualifier candidate;
                    bd = bf.getMergedBeanDefinition(beanName);
                    if (!(bd instanceof AbstractBeanDefinition) || ((candidate = (abd = (AbstractBeanDefinition)bd).getQualifier(Qualifier.class.getName())) == null || !qualifier.equals(candidate.getAttribute(AutowireCandidateQualifier.VALUE_KEY))) && !qualifier.equals(beanName) && !ObjectUtils.containsElement(bf.getAliases(beanName), qualifier)) break block5;
                    return true;
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
            }
            if (bd instanceof RootBeanDefinition && (factoryMethod = ((RootBeanDefinition)bd).getResolvedFactoryMethod()) != null && (targetAnnotation = factoryMethod.getAnnotation(Qualifier.class)) != null && qualifier.equals(targetAnnotation.value())) {
                return true;
            }
        }
        return false;
    }
}

