/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.model.CloudIdAndTimestampResponse;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.CloudTagsResponse;
import eu.europeana.cloud.common.response.CloudVersionRevisionResponse;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.mcs.driver.DataSetIterator;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.RepresentationIterator;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.DataSetAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetServiceClient
extends MCSClient {
    private final Client client = ClientBuilder.newClient();
    private static final Logger logger = LoggerFactory.getLogger(DataSetServiceClient.class);
    private static final String dataSetsPath;
    private static final String dataSetPath;
    private static final String assignmentsPath;
    private static final String dataSetRevisionsPath;
    private static final String representationsPath;
    private static final String latelyTaggedRecordsPath;
    private static final String revisionAndRepresentationPath;

    public DataSetServiceClient(String baseUrl) {
        super(baseUrl);
    }

    public DataSetServiceClient(String baseUrl, String username, String password) {
        this(baseUrl);
        this.client.register((Object)HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
    }

    public ResultSlice<DataSet> getDataSetsForProviderChunk(String providerId, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetsPath).resolveTemplate("DATAPROVIDER", (Object)providerId);
        if (startFrom != null) {
            target = target.queryParam("startFrom", new Object[]{startFrom});
        }
        return this.prepareResultSliceResponse(target);
    }

    public List<DataSet> getDataSetsForProvider(String providerId) throws MCSException {
        ResultSlice<DataSet> resultSlice;
        ArrayList<DataSet> resultList = new ArrayList<DataSet>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetsForProviderChunk(providerId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public DataSetIterator getDataSetIteratorForProvider(String providerId) {
        return new DataSetIterator(this, providerId);
    }

    public URI createDataSet(String providerId, String dataSetId, String description) throws ProviderNotExistsException, DataSetAlreadyExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetsPath).resolveTemplate("DATAPROVIDER", (Object)providerId);
        Form form = new Form();
        form.param("dataSetId", dataSetId);
        form.param("description", description);
        try (Response response = null;){
            response = target.request().post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                URI uRI = response.getLocation();
                return uRI;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public ResultSlice<Representation> getDataSetRepresentationsChunk(String providerId, String dataSetId, String startFrom) throws DataSetNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("DATASET", (Object)dataSetId);
        if (startFrom != null) {
            target = target.queryParam("startFrom", new Object[]{startFrom});
        }
        try (Response response = null;){
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = (ResultSlice)response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public List<Representation> getDataSetRepresentations(String providerId, String dataSetId) throws DataSetNotExistsException, MCSException {
        ResultSlice<Representation> resultSlice;
        ArrayList<Representation> resultList = new ArrayList<Representation>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRepresentationsChunk(providerId, dataSetId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public RepresentationIterator getRepresentationIterator(String providerId, String dataSetId) {
        return new RepresentationIterator(this, providerId, dataSetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDescriptionOfDataSet(String providerId, String dataSetId, String description) throws DataSetNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("DATASET", (Object)dataSetId);
        Form form = new Form();
        form.param("description", description);
        try (Response response = null;){
            response = target.request().put(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataSet(String providerId, String dataSetId) throws DataSetNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("DATASET", (Object)dataSetId);
        try (Response response = null;){
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRepresentationToDataSet(String providerId, String dataSetId, String cloudId, String representationName, String versionId) throws DataSetNotExistsException, RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(assignmentsPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("DATASET", (Object)dataSetId);
        Form form = new Form();
        form.param("cloudId", cloudId);
        form.param("representationName", representationName);
        form.param("version", versionId);
        try (Response response = null;){
            response = target.request().post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassignRepresentationFromDataSet(String providerId, String dataSetId, String cloudId, String representationName, String representationVersion) throws DataSetNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(assignmentsPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("DATASET", (Object)dataSetId).queryParam("cloudId", new Object[]{cloudId}).queryParam("representationName", new Object[]{representationName}).queryParam("version", new Object[]{representationVersion});
        Response response = null;
        try {
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public ResultSlice<CloudTagsResponse> getDataSetRevisionsChunk(String providerId, String dataSetId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp, String startFrom, Integer limit) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetRevisionsPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("DATASET", (Object)dataSetId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("REVISION_NAME", (Object)revisionName).resolveTemplate("REVISION_PROVIDER_ID", (Object)revisionProviderId).queryParam("revisionTimestamp", new Object[]{revisionTimestamp}).queryParam("startFrom", new Object[]{startFrom});
        if (limit != null) {
            target.queryParam("limit", new Object[]{limit});
        }
        Response response = null;
        try {
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = (ResultSlice)response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public List<CloudTagsResponse> getDataSetRevisions(String providerId, String dataSetId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp) throws MCSException {
        ResultSlice<CloudTagsResponse> resultSlice;
        ArrayList<CloudTagsResponse> resultList = new ArrayList<CloudTagsResponse>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRevisionsChunk(providerId, dataSetId, representationName, revisionName, revisionProviderId, revisionTimestamp, startFrom, null)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud ids and revision tags: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register((Object)new ECloudBasicAuthFilter(headerValue));
    }

    protected void finalize() throws Throwable {
        this.client.close();
    }

    public ResultSlice<CloudVersionRevisionResponse> getDataSetCloudIdsByRepresentationChunk(String dataSetId, String providerId, String representationName, String dateFrom, String tag, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(representationsPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("DATASET", (Object)dataSetId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).queryParam("creationDateFrom", new Object[]{dateFrom}).queryParam("tag", new Object[]{tag});
        if (startFrom != null) {
            target = target.queryParam("startFrom", new Object[]{startFrom});
        }
        return this.prepareResultSliceResponse(target);
    }

    public List<CloudVersionRevisionResponse> getDataSetCloudIdsByRepresentation(String dataSetId, String providerId, String representationName, String dateFrom, String tag) throws MCSException {
        ResultSlice<CloudVersionRevisionResponse> resultSlice;
        ArrayList<CloudVersionRevisionResponse> resultList = new ArrayList<CloudVersionRevisionResponse>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetCloudIdsByRepresentationChunk(dataSetId, providerId, representationName, dateFrom, tag, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud identifiers from data set: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public ResultSlice<CloudIdAndTimestampResponse> getLatestDataSetCloudIdByRepresentationAndRevisionChunk(String dataSetId, String providerId, String revisionProvider, String revisionName, String representationName, Boolean isDeleted, String startFrom) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(revisionAndRepresentationPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("REVISION_NAME", (Object)revisionName).resolveTemplate("REVISION_PROVIDER_ID", (Object)revisionProvider).resolveTemplate("DATASET", (Object)dataSetId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName);
        if (startFrom != null) {
            target = target.queryParam("startFrom", new Object[]{startFrom});
        }
        if (isDeleted != null) {
            target = target.queryParam("deleted", new Object[]{isDeleted});
        }
        return this.prepareResultSliceResponse(target);
    }

    private ResultSlice prepareResultSliceResponse(WebTarget target) throws MCSException {
        try (Response response = null;){
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                ResultSlice resultSlice = (ResultSlice)response.readEntity(ResultSlice.class);
                return resultSlice;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public List<CloudIdAndTimestampResponse> getLatestDataSetCloudIdByRepresentationAndRevision(String dataSetId, String providerId, String revisionProvider, String revisionName, String representationName, Boolean isDeleted) throws MCSException {
        ResultSlice<CloudIdAndTimestampResponse> resultSlice;
        ArrayList<CloudIdAndTimestampResponse> resultList = new ArrayList<CloudIdAndTimestampResponse>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getLatestDataSetCloudIdByRepresentationAndRevisionChunk(dataSetId, providerId, revisionProvider, revisionName, representationName, isDeleted, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud identifiers from data set: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public String getLatelyTaggedRecords(String dataSetId, String providerId, String cloudId, String representationName, String revisionName, String revisionProviderId) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(latelyTaggedRecordsPath).resolveTemplate("DATAPROVIDER", (Object)providerId).resolveTemplate("DATASET", (Object)dataSetId).queryParam("cloudId", new Object[]{cloudId}).queryParam("representationName", new Object[]{representationName}).queryParam("revisionName", new Object[]{revisionName}).queryParam("revisionProviderId", new Object[]{revisionProviderId});
        try (Response response = null;){
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                String string = (String)response.readEntity(String.class);
                return string;
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                String string = null;
                return string;
            }
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("data-providers");
        builder.append("/");
        builder.append("{");
        builder.append("DATAPROVIDER");
        builder.append("}/");
        builder.append("data-sets");
        dataSetsPath = builder.toString();
        builder.append("/");
        builder.append("{");
        builder.append("DATASET");
        builder.append("}");
        dataSetPath = builder.toString();
        builder.append("/");
        builder.append("assignments");
        assignmentsPath = builder.toString();
        StringBuilder dataSetRevisionsPathBuilder = new StringBuilder(dataSetPath);
        dataSetRevisionsPathBuilder.append("/").append("representations").append("/{").append("REPRESENTATIONNAME").append("}/").append("revisions").append("/{").append("REVISION_NAME").append("}/").append("revisionProvider").append("/{").append("REVISION_PROVIDER_ID").append("}");
        dataSetRevisionsPath = dataSetRevisionsPathBuilder.toString();
        representationsPath = dataSetPath + "/" + "representations" + "/{" + "REPRESENTATIONNAME" + "}";
        latelyTaggedRecordsPath = dataSetPath + "/latelyRevisionedVersion";
        revisionAndRepresentationPath = dataSetPath + "/revision" + "/{" + "REVISION_NAME" + "}/" + "revisionProvider" + "/{" + "REVISION_PROVIDER_ID" + "}/" + "representations" + "/{" + "REPRESENTATIONNAME" + "}";
    }
}

