/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.common.utils.FirstFlag;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DataSetIterator
implements Iterator<DataSet> {
    private final DataSetServiceClient client;
    private final String providerId;
    private FirstFlag firstTime = new FirstFlag();
    private String nextSlice = null;
    private Iterator<DataSet> dataSetListIterator;

    public DataSetIterator(DataSetServiceClient client, String providerId) {
        if (client == null) {
            throw new DriverException("DataSetServiceClient for DataSetIterator cannot be null");
        }
        this.client = client;
        if (providerId == null || providerId.equals("")) {
            throw new DriverException("ProviderId for DataSetIterator cannot be null/empty");
        }
        this.providerId = providerId;
    }

    @Override
    public boolean hasNext() {
        if (this.firstTime.unpack().booleanValue()) {
            this.obtainNextChunk();
        }
        return this.dataSetListIterator.hasNext() || this.nextSlice != null;
    }

    @Override
    public DataSet next() {
        if (this.firstTime.unpack().booleanValue()) {
            this.obtainNextChunk();
        }
        if (this.dataSetListIterator.hasNext()) {
            return this.dataSetListIterator.next();
        }
        if (this.nextSlice != null) {
            this.obtainNextChunk();
            return this.dataSetListIterator.next();
        }
        throw new NoSuchElementException("Calling next on exhausted DataSet iterator.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private void obtainNextChunk() {
        ResultSlice<DataSet> currentChunk;
        try {
            currentChunk = this.client.getDataSetsForProviderChunk(this.providerId, this.nextSlice);
        }
        catch (MCSException ex) {
            throw new DriverException("Error when trying to obtain DataSet list chunk for iterator", ex);
        }
        this.dataSetListIterator = currentChunk.getResults().iterator();
        this.nextSlice = currentChunk.getNextSlice();
    }
}

