/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.model.Permission;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.RepresentationRevisionResponse;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.CannotPersistEmptyRepresentationException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RevisionNotExistsException;
import eu.europeana.cloud.service.mcs.status.McsErrorCode;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordServiceClient
extends MCSClient {
    private final Client client = (Client)ClientBuilder.newClient().register(MultiPartFeature.class);
    private static final Logger logger = LoggerFactory.getLogger(DataSetServiceClient.class);
    private static final String recordPath;
    private static final String representationsPath;
    private static final String represtationNamePath;
    private static final String versionsPath;
    private static final String versionPath;
    private static final String copyPath;
    private static final String persistPath;
    private static final String grantingPermissionsToVesionPath;
    private static final String permitPath;
    private static final String representationsRevisionsPath;

    public RecordServiceClient(String baseUrl) {
        super(baseUrl);
    }

    public RecordServiceClient(String baseUrl, String username, String password) {
        this(baseUrl);
        this.client.register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register(new ECloudBasicAuthFilter(headerValue));
    }

    public Record getRecord(String cloudId) throws RecordNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(recordPath).resolveTemplate("CLOUDID", cloudId);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                Record record = response.readEntity(Record.class);
                return record;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(String cloudId) throws RecordNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(recordPath).resolveTemplate("CLOUDID", cloudId);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public List<Representation> getRepresentations(String cloudId) throws RecordNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(representationsPath).resolveTemplate("CLOUDID", cloudId);
        Response response = null;
        try {
            response = target.request().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List<Representation> list = response.readEntity(new GenericType<List<Representation>>(){});
                return list;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public Representation getRepresentation(String cloudId, String representationName) throws RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(represtationNamePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode() || response.getStatus() == Response.Status.TEMPORARY_REDIRECT.getStatusCode()) {
                Representation representation;
                Representation representation2 = representation = response.readEntity(Representation.class);
                return representation2;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId) throws ProviderNotExistsException, RecordNotExistsException, MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(this.baseUrl).path(represtationNamePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName);
            Invocation.Builder request = target.request();
            Form form = new Form();
            form.param("providerId", providerId);
            response = null;
            try {
                URI uri;
                response = request.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = uri = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, InputStream data, String fileName, String mediaType) throws MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(this.baseUrl).path(represtationNamePath + "/files").resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName);
            Invocation.Builder request = target.request();
            FormDataMultiPart multipart = this.prepareRequestBody(providerId, data, fileName, mediaType);
            response = null;
            request.header("Content-Type", "multipart/form-data");
            try {
                URI uri;
                response = request.post(Entity.entity(multipart, "multipart/form-data"));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = uri = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId, InputStream data, String mediaType) throws MCSException {
        return this.createRepresentation(cloudId, representationName, providerId, data, null, mediaType);
    }

    private FormDataMultiPart prepareRequestBody(String providerId, InputStream data, String fileName, String mediaType) {
        FormDataMultiPart requestBody = new FormDataMultiPart().field("providerId", providerId).field("data", data, MediaType.APPLICATION_OCTET_STREAM_TYPE).field("mimeType", mediaType);
        if (fileName != null && !"".equals(fileName.trim())) {
            requestBody.field("fileName", fileName);
        }
        return requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRepresentation(String cloudId, String representationName) throws RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(represtationNamePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public List<Representation> getRepresentations(String cloudId, String representationName) throws RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(versionsPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List<Representation> list;
                List<Representation> list2 = list = response.readEntity(new GenericType<List<Representation>>(){});
                return list2;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public Representation getRepresentation(String cloudId, String representationName, String version) throws RepresentationNotExistsException, MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path(versionPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
        Invocation.Builder request = webtarget.request();
        Response response = null;
        try {
            response = request.get();
            System.out.println(response);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                Representation representation;
                Representation representation2 = representation = response.readEntity(Representation.class);
                return representation2;
            }
            try {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
            catch (MessageBodyProviderNotFoundException e) {
                String out = webtarget.getUri().toString();
                throw new MCSException(out, e);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRepresentation(String cloudId, String representationName, String version) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path(versionPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
        Invocation.Builder request = webtarget.request();
        Response response = null;
        try {
            response = request.delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public URI copyRepresentation(String cloudId, String representationName, String version) throws RepresentationNotExistsException, MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(this.baseUrl).path(copyPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
            Invocation.Builder request = target.request();
            response = null;
            try {
                response = request.post(Entity.entity(new Form(), MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI persistRepresentation(String cloudId, String representationName, String version) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, CannotPersistEmptyRepresentationException, MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(this.baseUrl).path(persistPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
            Form form = new Form();
            Invocation.Builder request = target.request();
            response = null;
            try {
                URI uri;
                response = request.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = uri = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPermissionsToVersion(String cloudId, String representationName, String version, String userName, Permission permission) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(grantingPermissionsToVesionPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("PERMISSION_TYPE", permission.getValue()).resolveTemplate("USERNAME", userName);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(null);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                this.throwException(response);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePermissionsToVersion(String cloudId, String representationName, String version, String userName, Permission permission) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(grantingPermissionsToVesionPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("PERMISSION_TYPE", permission.getValue()).resolveTemplate("USERNAME", userName);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void permitVersion(String cloudId, String representationName, String version) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(permitPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(null);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                this.throwException(response);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    private void throwException(Response response) throws MCSException {
        try {
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        catch (MessageBodyProviderNotFoundException e) {
            ErrorInfo errorInfo = new ErrorInfo();
            errorInfo.setErrorCode(McsErrorCode.OTHER.toString());
            errorInfo.setDetails("Mcs not available");
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    protected void finalize() throws Throwable {
        this.client.close();
    }

    public RepresentationRevisionResponse getRepresentationRevision(String cloudId, String representationName, String revisionName, String revisionProviderId, String revisionTimestamp) throws RevisionNotExistsException, MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path(representationsRevisionsPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("REVISION_NAME", revisionName);
        if (revisionProviderId == null) {
            throw new MCSException("RevisionProviderId is required");
        }
        webtarget = webtarget.queryParam("revisionProviderId", revisionProviderId);
        if (revisionTimestamp != null) {
            webtarget = webtarget.queryParam("revisionTimestamp", revisionTimestamp);
        }
        Invocation.Builder request = webtarget.request();
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                RepresentationRevisionResponse representationRevisionResponse;
                RepresentationRevisionResponse representationRevisionResponse2 = representationRevisionResponse = response.readEntity(RepresentationRevisionResponse.class);
                return representationRevisionResponse2;
            }
            try {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
            catch (MessageBodyProviderNotFoundException e) {
                String out = webtarget.getUri().toString();
                throw new MCSException(out, e);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("records");
        builder.append("/");
        builder.append("{");
        builder.append("CLOUDID");
        builder.append("}");
        recordPath = builder.toString();
        builder.append("/");
        builder.append("representations");
        representationsPath = builder.toString();
        builder.append("/");
        builder.append("{");
        builder.append("REPRESENTATIONNAME");
        builder.append("}");
        represtationNamePath = builder.toString();
        builder.append("/");
        builder.append("versions");
        versionsPath = builder.toString();
        builder.append("/");
        builder.append("{");
        builder.append("VERSION");
        builder.append("}");
        versionPath = builder.toString();
        copyPath = versionPath + "/" + "copy";
        persistPath = versionPath + "/" + "persist";
        permitPath = versionPath + "/" + "permit";
        grantingPermissionsToVesionPath = versionPath + "/permissions/{" + "PERMISSION_TYPE" + "}/users/{" + "USERNAME" + "}";
        representationsRevisionsPath = represtationNamePath + "/revisions/{" + "REVISION_NAME" + "}";
    }
}

