/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.mcs.driver.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServiceClient
extends MCSClient {
    private final Client client;
    private static final Logger logger = LoggerFactory.getLogger(FileServiceClient.class);
    private static final String filesPath = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/files";
    private static final String filePath = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/files/{FILENAME}";

    public FileServiceClient(String baseUrl) {
        super(baseUrl);
        this.client = (Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class);
    }

    public FileServiceClient(String baseUrl, String username, String password) {
        super(baseUrl);
        this.client = (Client)((Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class)).register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName) throws RepresentationNotExistsException, FileNotExistsException, DriverException, MCSException, IOException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
        Invocation.Builder requset = target.request();
        Response response = null;
        try {
            response = requset.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                InputStream contentResponse = response.readEntity(InputStream.class);
                InputStream inputStream = this.copiedInputStream(contentResponse);
                return inputStream;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName, String range) throws RepresentationNotExistsException, FileNotExistsException, WrongContentRangeException, DriverException, MCSException, IOException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
        Invocation.Builder request = target.request().header("Range", range);
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.PARTIAL_CONTENT.getStatusCode()) {
                InputStream contentResponse = response.readEntity(InputStream.class);
                InputStream inputStream = this.copiedInputStream(contentResponse);
                return inputStream;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public InputStream getFile(String fileUrl) throws RepresentationNotExistsException, FileNotExistsException, WrongContentRangeException, DriverException, MCSException, IOException {
        Response response;
        block3: {
            response = null;
            try {
                response = this.client.target(fileUrl).request().get();
                if (response.getStatus() != Response.Status.OK.getStatusCode()) break block3;
                InputStream contentResponse = response.readEntity(InputStream.class);
                InputStream inputStream = this.copiedInputStream(contentResponse);
                this.closeResponse(response);
                return inputStream;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String cloudId, String representationName, String version, InputStream data, String mediaType, String expectedMd5) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block4: {
            WebTarget target = this.client.target(this.baseUrl).path(filesPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
            FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            Invocation.Builder request = target.request();
            response = null;
            try {
                response = request.post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block4;
                if (!expectedMd5.equals(response.getEntityTag().getValue())) {
                    throw new IOException("Incorrect MD5 checksum");
                }
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String cloudId, String representationName, String version, InputStream data, String mediaType) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(this.baseUrl).path(filesPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
            FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            Invocation.Builder request = target.request();
            response = null;
            try {
                response = request.post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String cloudId, String representationName, String version, String fileName, InputStream data, String mediaType) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(this.baseUrl).path(filesPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
            FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", data, MediaType.APPLICATION_OCTET_STREAM_TYPE).field("fileName", fileName);
            Invocation.Builder request = target.request();
            response = null;
            try {
                response = request.post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String versionUrl, InputStream data, String mediaType) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block3: {
            String filesPath = "/files";
            FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            response = null;
            try {
                response = this.client.target(versionUrl + filesPath).request().post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI modyfiyFile(String cloudId, String representationName, String version, InputStream data, String mediaType, String fileName, String expectedMd5) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block4: {
            WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
            FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            response = null;
            try {
                response = target.request().put(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) break block4;
                if (!expectedMd5.equals(response.getEntityTag().getValue())) {
                    throw new IOException("Incorrect MD5 checksum");
                }
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI modifyFile(String fileUrl, InputStream data, String mediaType) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(fileUrl);
            FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            response = null;
            try {
                response = target.request().put(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) break block3;
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String cloudId, String representationName, String version, String fileName) throws RepresentationNotExistsException, FileNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
        Response response = null;
        try {
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public URI getFileUri(String cloudId, String representationName, String version, String fileName) {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
        return target.getUri();
    }

    public static Map<String, String> parseFileUri(String uri) {
        Pattern p = Pattern.compile(".*/records/([^/]+)/representations/([^/]+)/versions/([^/]+)/files/(.*)");
        Matcher m = p.matcher(uri);
        if (m.find()) {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put("CLOUDID", m.group(1));
            ret.put("REPRESENTATIONNAME", m.group(2));
            ret.put("VERSION", m.group(3));
            ret.put("FILENAME", m.group(4));
            return ret;
        }
        return null;
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register(new ECloudBasicAuthFilter(headerValue));
    }

    private InputStream copiedInputStream(InputStream originIS) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = originIS.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    protected void finalize() throws Throwable {
        this.client.close();
    }
}

